define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.DocumentView = Backbone.View.extend({
		tmpl: "#document-tmpl",

		className: "document-item item-type-document",

		// Known image extensions
		imageExtensions: [
			'jpg', 'jpeg', 'png', 'gif'
		],

		initialize: function (options) {
			this.options = options;
			_.bindAll(this, "render");
		},

		render: function () {
			var
				// Hack around the fact the title can be called "title" or "realname"
				title = this.model.get("title") || this.model.get("realname"),
				// Split the file name down in to parts
				fileParts = title.split('.'),
				// Attempt to grab the extension
				ext = fileParts.pop().toLowerCase(),
				//Max number of filename characters to display
				maxLength = 128,
				lightbox = this.imageExtensions.indexOf(ext) >= 0,
				outputTitle;

			// encode + symbols manually
			var url = encodeURIComponent(title);

			if (title.length > maxLength && ext.length != title.length) {
				//If title is too long and it has an extension
				outputTitle = title.substr(0, maxLength - (3 + ext.length)) + "..." + ext;
			} else if (ext.length == title.length) {
				//If the title doesn't have an extension
				outputTitle = title.substr(0, maxLength - 3) + "...";
			} else {
				//It title is short
				outputTitle = title;
			}

			var is_multiple = this.model.get("pc_title") !== this.model.get("title");
			this.model.set('is_multiple', is_multiple);
			this.model.set("title", title);
			this.model.set("pc_title", encodeURIComponent(this.model.get("pc_title")));
			this.model.set("outputTitle", outputTitle);
			this.model.set("url", url);

			// If it's an image, set the lightbox property to true
			// Otherwise set it to false
			// Used in the tmpl for determining the URL etc.
			this.model.set("lightbox", lightbox);

			// what to do with the document after click?
			// if not an image we can 'download' or 'preview'
			this.model.set("documentAction", this.options.instance.documentAction);

			// Should documents open in a new window?
			this.model.set('newWindow', this.options.instance.newWindow);

			// Draw our $el
			this.$el.html($(this.tmpl).tmpl(this.model.toJSON()));

			// Again, if it's an image, attach the lightbox
			if (lightbox) {
				this.$el.find("a.lightbox-trigger").data('lightbox');
			}

			return this;
		}
	})
});
