// The Folder model
// ----------------

define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.Folder = Backbone.Model.extend({
		initialize: function(options) {
			this.options = options;
		},

		defaults: {
			id: undefined,
			title: undefined
		},

		url: function() {
			if(this.isNew()) {
				return "/intranet/rest/documents/folder/" + this.options.activeFolder + "/folders";
			} else {
				return "/intranet/rest/documents/folder/" + this.get("id");
			}
		},

		validate: function() {
			if(!this.get("title") || this.get("title").length === 0) {
				return "A folder name must be specified";
			}
		}
	});

	return DMSV;
});
