define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.FolderView = Backbone.View.extend({
		tmpl: "#folder-tmpl",

		className : "document-item item-type-folder",

		events: {
			"click .folder-link": "folderClicked"
		},

		initialize: function(options) {
			_.bindAll(this, "render");
			this.options = options;
		},

		// When navigating folders
		folderClicked: function() {
			// Set the global activeFolderObj property
			this.options.instance.activeFolderObj = this.model;
			// Set the global activeFolder ID
			this.options.instance.activeFolder = this.model.get("id");
			// Fetch the new stuff
			this.options.instance.objectCollection.fetch();
			// Fetch the breadcrumb stuff
			this.options.instance.breadcrumbCollection.fetch();
			// Trigger buttons redraw
			this.options.instance.addFolderDocumentButtons.redraw();

			if (this.options.instance.options.$addDocumentButton.hasClass('js-detailed-upload')) {
                this.options.instance.options.$addDocumentButton.prop('href', this.options.instance.options.addDocumentUrl + '?fid=' + this.options.instance.activeFolder);
            } else {
                this.options.instance.options.$addDocumentPopup.find("[name='fid']").val(this.options.instance.activeFolder);
            }

			return false;
		},

		render: function() {
			// Again, because the structure of our model differs depending on a search or documents GET
			// we have to worm around this
			var data = this.model.toJSON();
			data.title = data.title || data.realname;

			var maxLength = 50;
			if (data.title.length > maxLength) {
				data.outputTitle = data.title.substr(0, maxLength - 3) + "...";
			} else {
				data.outputTitle = data.title;
			}

			this.$el.html($(this.tmpl).tmpl(data));

			return this;
		}
	});

	return DMSV;
});
