// The Object Collection
// ----------------------
// Responsible for grabbing Folders/Documents data from the server
// with an optional limit, offset and search query

define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.ObjectCollection = Backbone.Collection.extend({
		initialize: function(options) {
			this.options = options;
		},

		// The offset
		start: 0,
		// The limit
		num: 50,
		// Whether we have more to load
		more_to_load: false,

		url: function() {
			return "/intranet/rest/documents/folder/" + this.options.instance.activeFolder;
		},

		fetch: function(ext_options) {
			var self = this;

			// Ensure we have an options object
			var options = {};

			ext_options = ext_options || {};

			// Ensure we have the data property
			options.data = {};

			// If we're not adding, we're resetting. So start from 0 again
			if (!ext_options.add) {
				this.start = 0;
				options.reset = true;
			}
			// Apply pagination options
			options.data.start = this.start;
			options.data.num = this.num;

			// Show the loader
			options.beforeSend = function() {
				self.options.spinner.show();
			};
			options.complete = function() {
	            if (self.options.spinner.is(':visible')) {
		            self.options.spinner.fadeOut();
	            } else {
		            self.options.spinner.hide();
	            }
			};

			// Are we doing a search?
			if(this.options.instance.search && !_.isEmpty(this.options.instance.search.get("query"))) {
				options.data.folder_id = this.options.instance.activeFolder;
				options.data.with_subfolders = 1;
				options.data.keywords = this.options.instance.search.get("query");
				options.url = this.url();
			}

			success = function(collection, json) {
				// Check whether we've received the limit
				self.more_to_load = json.length == self.num;
				// Trigger an event for the DMSVShowMoreView
				self.trigger("updateShowMore");

				// Call the optional callback method
				// Callback method should be named "successCallback" instead of "success"
				if(options.successCallback) {
					options.successCallback.call(collection, json);
				}
			};

			// Assign the success callback
			options.success = success;
			options.error = function(collection, json) {};

			_.extend(options, ext_options);

			// super.Collection.fetch()
			Backbone.Collection.prototype.fetch.call(this, options);
		},

		// Called on "Show More"
		fetchMore: function(options) {
			this.start = this.start + this.num;
			options = options || {};
			options.add = true;
			options.update = true;
			options.remove = false;
			this.fetch(options);
		},

		// The response structure differs from normal requests
		// to search requests
		parse: function(response) {
			if(response.results) {
				return response.results;
			}
			return response;
		}
	});

	return DMSV;
});
