define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.ShowMoreView = Backbone.View.extend({
		events: {
			"click .js-show-more-link": "fetchMore"
		},

		initialize: function(options) {
			_.bindAll(this, "fetchMore", "render");
			this.options = options;
			this.options.instance.objectCollection.on("updateShowMore", this.render);
		},

		fetchMore: function(event) {
			this.options.instance.objectCollection.fetchMore();
			return false;
		},

		render: function(event) {
			this.$el.find(".js-show-more-link").toggle(this.options.instance.objectCollection.more_to_load === true);
			return this;
		}
	});

	return DMSV;
});
