# Claromentis DMSV

The Claromentis Document Management System View Component allows you to embed a view in to your DMS application from any page / application.

[![](screenshot.png)](screenshot.png)

## Installation

### Via Composer

Add `"claromentis/dmsv":"*"` to `modules.json` and run installer.

### Using Git

Clone the repository to `web/intranet/dmsv/`.

Then run this command from "application" folder

```
./clc app:install dmsv
```

## How to use

This component can be added to a Pages page. Search for DMSV when adding a component to a page.

It can also be used in application templates.

Use the following Templater Component element and define the `root_folder` ID attribute:

```html
<component class="\Claromentis\Dmsv\UI\DmsvComponent" root_folder="1" action="download">
```

Attributes can be provided via Templater arguments if the component has a `name`:

```html
<component name="my_dmsv_component" class="\Claromentis\DMSV\UI\DmsvComponent"/>
```

```php
$args['my_dmsv_component.root_folder'] = $root_folder;
$args['my_dmsv_component.action'] = 'download';
$args['my_dmsv_component.detailed_upload'] = 1;
$args['my_dmsv_component.new_window'] = 0;
$args['my_dmsv_component.view'] = 'list';

return new TemplaterCallResponse('my_template.html', $args);
```

### Parameters

| Parameter         | Description                                                                                                                           |
| ---               | ---                                                                                                                                   |
| `root_folder`     | **Required.** Root folder of the document structure.<br/>`0` is the root folder in Documents, and is not allowed to be used for DMSV. |
| `action`          | `"download"` or `"preview"`. Defaults to `"download"`. Decides what happens when non-image Documents are clicked.                     |
| `detailed_upload` | Setting to `1` forces the component to use document detailed upload.                                                                  |
| `new_window`      | Setting to `1` forces all documents to open in a new window.                                                                          |
| `view`            | Set to `list` to display documents in list view by default.                                                                           |

