// View for the List/Icon buttons
// -------------------------------

define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
    var localStorage = window.localStorage;

	DMSV.prototype.StyleSwitchView = Backbone.View.extend({
		events: {
			"click a": "switchStyle"
		},

		initialize: function(options) {
			this.options = options;

            if (this.isLocalStorageAvailable()) {
                var localStorageKey = 'user_setting_view_is_list_view_' + this.options.rootFolder;
                var isListView = localStorage.getItem(localStorageKey);

                if (!!isListView)
                {
                    // set picked view by user
                    $(this.options.listEl).attr("class", "").addClass(this.getListViewClass(isListView));

                    // set class active for the picked button
                    $('.btn-group.ml-2.js-view-style > a').each(function (i, a) {
                        $(a).removeClass("active");

                        if (isListView === '1' && $(a).attr('name') === 'list_view_button')
                            $(a).addClass('active');

                        if (isListView === '0' && $(a).attr('name') === 'icon_view_button')
                            $(a).addClass('active');
                    });
                }
            }
		},

		switchStyle: function(ev) {
			el = ev.target.tagName.toLowerCase() === "span" ? $(ev.target).parent() : $(ev.target);

			el.parent().find("a").each(function(i, a) {
				$(a).removeClass("active");
			});
			el.addClass("active");
			$(this.options.listEl).attr("class", "").addClass(el.data('set-class'));

            if (!this.isLocalStorageAvailable())
                return false;

            var localStorageKey = 'user_setting_view_is_list_view_' + this.options.rootFolder;

            if (el.data('set-class') === 'min-list-view')
                localStorage.setItem(localStorageKey, '1');
            else
                localStorage.setItem(localStorageKey, '0');

            return false;
		},

        getListViewClass: function (isListView)
        {
            return isListView === '1' ? 'min-list-view' : 'icons-view';
        },

        /**
         * Check if local storage is available.
         *
         * @returns {boolean}
         */
        isLocalStorageAvailable: function () {
            try {
                var test = 'test';
                localStorage.setItem(test, '1');
                localStorage.removeItem(test);
                return true;
            } catch (e) {
                return false;
            }
        }
    });

	// View wrapping the Create Folder modal
	// --------------------------------------
	DMSV.prototype.CreateFolderView = Backbone.View.extend({
		events: {
			"click .btn-primary": "addFolder",
			"hidden" : "hidden"
		},

		initialize: function(options) {
			this.options = options;
		},

		hidden: function() {
			this.$el.find('.js-dmsv-add-folder-link').tooltip('hide');
		},

		// Add folder button clicked
		addFolder: function(event) {
			var formTarget = $(event.target).data('dmsv_prefix');
			if (formTarget !== this.options.prefix)
				return;

			var self = this, error;
			var folder = new this.options.instance.Folder({ title: this.$el.find("input[name=folder_title]").val(), activeFolder: this.options.instance.activeFolder });
			error = folder.validate();
			if(error) {
				alert(error);
				return false;
			}

			//clean-up
			self.$el.find("input[name=folder_title]").val('');
			self.$el.modal("hide");

			folder.save(undefined, {
				success: function() {
					self.options.instance.objectCollection.fetch();
				},
				error: function(model, xhr, options) {
					if(cla) {
						cla.showMessage(xhr.responseText, '', true);
					}
				}
			});

			return false;
		}
	});

	// View wrapping the Add Document modal button
	// -------------------------------------
	DMSV.prototype.AddDocumentModalView = Backbone.View.extend({
		events: {
			"click .js-dmsv-add-document-link": "openModal"
		},

		initialize: function(options) {
			this.options = options;
		},

		openModal: function() {
			if (!this.options.instance.breadcrumbCollection.draft_only)
			{
				$('#draft_only_notify').hide();
				$('#fg_draft_select').show();
			}else
			{
				$('#draft_only_notify').show();
				$('#fg_draft_select').hide();
			}
		}
	});

	// View wrapping the Add Document button
	// -------------------------------------
	DMSV.prototype.AddDocumentView = Backbone.View.extend({
		events: {
			"click .btn-primary": "addDocument",
			"hidden" : "hidden"
		},

		initialize: function(options) {
			this.options = options;
		},

		hidden: function() {
			this.$el.find('.js-dmsv-add-document-link').tooltip('hide');
		},

		addDocument: function(event) {
			var formTarget = $(event.target).data('dmsv_prefix');
			if (formTarget !== this.options.prefix)
				return;

			var addRecipients = this.$el.find('input[name="notification_type"]').prop('checked');
			var is_draft = $('#dmsv-instance-' + this.options.prefix + ' input[name=is_draft]').prop('checked');
			var is_multi_component = $('#dmsv-instance-' + this.options.prefix + ' input[name=multi_component]:checked').val();
			var multi_component_filename = null;
			var self = this;

			if (is_multi_component == 1)
			{
				multi_component_filename = $('#dmsv-instance-' + this.options.prefix + ' input[name=doc_title]').val();

				// gather components
				var components = [];
				var set_primary = true;
				_.each(fuu_obj.GetFiles(), function(file){
					var tmp_comp = {
						file_key: file.file_key,
						name:file.file_name
					};
					if (set_primary){
						tmp_comp.is_primary = true;
						if (multi_component_filename == null || multi_component_filename == ''){
							// if no filename supplied, use the primary component's filename
							multi_component_filename = file.file_name;
						}
						set_primary = false;
					}
					else
					{
						tmp_comp.is_primary = false;
					}
					components.push(tmp_comp);
				});

				self.options.instance.objectCollection.create(
					new self.options.instance.Document({
						activeFolder: self.options.instance.activeFolder,
						title: multi_component_filename,
						metadata: {description: self.$el.find('#description').val()},
						components: components,
						is_draft: is_draft
					}),	{
						wait: true,
						error: function(model, xhr, options) {
							if(cla) {
								cla.showMessage(xhr.responseText, '', true);
							}
						},
						success: function(info, document, response) {
							if (addRecipients)
								window.location.href = '/intranet/documents/doc_send_notify.php?id=' + document.doc_id + '&parent_id=' + document.parent_id;
						}
					}
				);
			}
			else
			{
				_.each(fuu_obj.GetFiles(), function(file) {
					self.options.instance.objectCollection.create(
						new self.options.instance.Document({
							activeFolder: self.options.instance.activeFolder,
							title: file.file_name,
							components: [{	file_key: file.file_key,
								is_primary: true
							}],
							is_draft: is_draft
						}),	{
							wait: true,
							error: function(model, xhr, options) {
								if(cla) {
									cla.showMessage(xhr.responseText, '', true);
								}
							},
							success: function(info, document, response) {
								if (addRecipients)
									window.location.href = '/intranet/documents/doc_send_notify.php?id=' + document.doc_id + '&parent_id=' + document.parent_id;
							}
						}
					);
				});
			}

			//clean-up
			var popup = $('#add_doc_form');
			popup.find('.dd_selected_files').empty();
			popup.find('.dd_keep_pre_uploaded').hide();
			popup.find('.dd_extract_archive_div').hide();
			popup.find('#multiple_files_block-' + self.options.prefix).empty();
			popup.find('#description').val('');
			popup.find('input[name="notification_type"]').prop('checked', false);
			this.$el.modal("hide");
			return false;
		}
	});

	// View wrapping the "Add Document" and "Add Folder" button
	// --------------------------------------------------------
	DMSV.prototype.AddFolderDocumentButtons = Backbone.View.extend({
		initialize: function(options) {
			_.bindAll(this, "redraw");
			this.options = options;
			this.options.instance.breadcrumbCollection.on("sync", this.redraw);
		},

		redraw: function() {
			var add_folder = false;
			var add_doc = false;
			if(this.options.instance.activeFolder === 0) {
	            add_folder = this.options.root_edit;
	            add_doc = this.options.root_edit;
			} else {
				add_folder = this.options.instance.breadcrumbCollection.add_folder;
				add_doc = this.options.instance.breadcrumbCollection.add_doc;
			}

			var self = this;

			this.$el.find(".js-dmsv-add-folder-link").toggle(add_folder);
			this.$el.find(".js-dmsv-add-folder-link").on('click', function()
			{
				$('#dmsv_folder_popup .btn-primary').data('dmsv_prefix', self.options.prefix);
			});
			this.$el.find(".js-dmsv-add-document-link").toggle(add_doc && this.options.instance.activeFolder !== 0);
			this.$el.find(".js-dmsv-add-document-link").on('click', function()
			{
				$('#add_doc_form .btn-primary').data('dmsv_prefix', self.options.prefix);
			});


			this.$el.find(".js-dmsv-add-folder-span").toggle(!add_folder);
			this.$el.find(".js-dmsv-add-document-span").toggle(!add_doc && this.options.instance.activeFolder !== 0);
		}
	});

	// View wrapping the "View in Documents" link
	// ------------------------------------------
	DMSV.prototype.ViewInDMSView = Backbone.View.extend({
		initialize: function(options) {
			_.bindAll(this, "update");
			this.options = options;
			this.options.instance.objectCollection.on("all", this.update);
		},

		update: function() {
			this.$el.prop("href", "/intranet/documents/" + this.options.instance.activeFolder);
		}
	});

	// Search box View
	// ---------------
	DMSV.prototype.SearchView = Backbone.View.extend({
		events: {
			"keyup .js-search-term": "search",
			"keydown .js-search-term": "detectEnter",
			"click .search-reset": "clearSearch"
		},

		initialize: function(options) {
			_.bindAll(this, "search");
			this.options = options;
		},

		// Detect enter keydown events and prevent them
		detectEnter: function(ev) {
			// Prevent enter from doing it's thing
			if(ev.keyCode === 13) {
				return false;
			}
		},

		// Perform the search on keyup
		// Will wait 0.5 seconds before performing the search
		search: function(ev) {
			var self = this;

			// No point going through on enter
			if(_.isObject(ev) && ev.keyCode === 13) {
				return false;
			}

			// Timer already running? End it.
			if(this.options.timer !== undefined) {
				clearTimeout(this.options.timer);
				this.options.timer = undefined;
			}

			// Start a search timer
			this.options.timer = setTimeout(function() {
				self.model.set({ query: self.$el.find(".js-search-term").val() });
				self.options.instance.objectCollection.fetch();
			}, 500);

			return false;
		},

		// Clear the search field
		clearSearch: function() {
			this.$el.find(".js-search-term").val('');
			this.search();

			return false;
		}
	});

	// temporary changes for buttons "Detailed Upload" and "Extended Edit"

	DMSV.prototype.DetailedUploadView = Backbone.View.extend({
		initialize: function(options) {
			this.options = options;
		},

		events: {
			"click input[name='ext_edit']": "detailedUpload"
		},

		detailedUpload: function() {
			this.$el.find('input[name="fid"]').val(this.options.instance.activeFolder);
			this.$el.find('form').prop('action', '/intranet/documents/add_doc.php');

			return true;
		}
	});

	DMSV.prototype.ExtendedEditView = Backbone.View.extend({
		el: "",
		initialize: function(options) {
			this.options = options;
		},

		events: {
			"click input[name='ext_edit']": "extendedEdit"
		},

		extendedEdit: function() {
			this.$el.find('input[name="parent_id"]').val(this.options.instance.activeFolder);
			this.$el.find('form').prop('action', '/intranet/documents/add_folder.php');

			return true;
		}
	});

	return DMSV;
});
