// View wrapping the existing Breadcrumb container
// -----------------------------------------------

define(['../dms_view.js', 'backbone'], function(DMSV, Backbone)
{
	DMSV.prototype.BreadcrumbView = Backbone.View.extend({
		events: {
			"click .breadcrumb-item": "itemClicked"
		},

		initialize: function(options) {
			this.options = options;
			_.bindAll(this, "change");
			this.options.collection.on("add", this.change);
			this.options.collection.on("remove", this.change);
		},

		// Breadcrumb item clicked
		itemClicked: function(el) {
			this.options.instance.activeFolder = parseInt($(el.target).attr("id").split("-")[2], 10);
			this.options.instance.objectCollection.fetch();
			this.options.collection.fetch();

            if (this.options.instance.options.$addDocumentButton.hasClass('js-detailed-upload')) {
                this.options.instance.options.$addDocumentButton.prop('href', this.options.instance.options.addDocumentUrl + '?fid=' + this.options.instance.activeFolder);
            } else {
                this.options.instance.options.$addDocumentPopup.find("[name='fid']").val(this.options.instance.activeFolder);
            }

			return false;
		},

		// Reset the breadcrumb items
		change: function() {
			this.$el.find("li.dynamic-li").remove();

			var self = this;
			this.options.collection.each(function(item) {
				this.$el.append(new self.options.instance.BreadcrumbItemView({ model: item, instance: self.options.instance }).render().el);
			}, this);
		}
	});

	// View for dynamic breadcrumb items
	// ---------------------------------
	DMSV.prototype.BreadcrumbItemView = Backbone.View.extend({
		tagName: "li",
		className: "dynamic-li breadcrumb-item",
		tmpl: "#breadcrumb-item-tmpl",

		initialize: function(options) {
			this.options = options;
			_.bindAll(this, "render");
		},

		render: function() {
			// Determine whether we're the first and last item
			this.model.set({ first_item: this.options.instance.breadcrumbCollection.first() === this.model });
			this.model.set({ last_item: this.options.instance.breadcrumbCollection.last() === this.model });
			this.$el.html($(this.tmpl).tmpl(this.model.toJSON()));
			this.$el.attr('title', this.model.get('title'))

			if (this.model.get('last_item'))
                this.$el.addClass("active");

			return this;
		}
	});

	return DMSV;
});
