# Events #

Events module allows organisation to create an events including training classes and webinar, invite users to join, manage attendees and run a report. 

### Requirements ###
* Claromentis 8.0
* Learning 1.0.2+ (for Training Records and deployment of LMS Platform in general)

### Installation ###

Via composer:
  * Add `"claromentis/events": "*"` to `modules.json`
  * From the application folder, run `./clc resolve`

Manually:
  * Copy Events code into 'intranet/events/' folder
  * Run:

```sh
./clc app:install events
```

...or if there is a previous version of Events installed run:

```sh
./clc app:upgrade events
```

### Other Settings ###

**Calendar Integration** - Events can be made appear in System Calendar : Events

**Predictive Location Input** - An API (server) key for the GoogleMap API service is required. 
This should be set up specifically for each installation and can be done in Admin Panel

Admin > System > API keys -> Google Maps API Key (See https://discover.claromentis.com/knowledgebase/articles/385 for details )

See https://console.developers.google.com/apis/dashboard


### Component Installation ###

Copy the component code from the repository.

### Component Usage ###
 
Add the Events component to a page thus:
```
<component class="\Claromentis\Events\UI\UpcomingEvents" />
```

Available options are:
* **title** -         E.g. "Coming Up"
* **categories** -    "0" = all event categories (default), "2,6,4" = events from categories 2, 4 and 6
* **limit** -         Maximum number of events to display (default is "5")
* **show_images** -   "0" = don't show event image, "1" = show event image (default)
* **training_only** - "0" = show training and non-training events (default), "1" = only show training events
* **attend_only** -   "0" = show events user can view (default), "1" = only show events that user can attend 
