<?php
$_db_migration_to = '03.01';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_learning_columns.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('events_event', 'joining_details', 'VARCHAR_MAX NULL');
$db->AddColumn('events_event', 'qualification_code', 'VARCHAR(255) NULL DEFAULT NULL');
$db->AddColumn('events_event', 'has_training_record', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('02_index_events_event.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->CreateIndex('events_event', 'index_sequence_id', 'sequence_id', 'date_start');
DB_UPDATE_FILE
);


$migrations->Run('03_add_approval_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('events_event', 'approval', 'INT NOT_NULL DEFAULT 0');
DB_UPDATE_FILE
);


$migrations->Run('04_rename_waiting_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// store waiting list content in temporary table along with record id

if ($db->type() != 'mysql')
{
    $q = new \Claromentis\Core\DAL\Query("SELECT id, waiting INTO #temp_statuses FROM events_participant");

    $r = $db->query($q);

    $db->DropColumn('events_participant', 'waiting');
    $db->AddColumn('events_participant', 'status', 'INT NOT_NULL DEFAULT 0');

    $q = new \Claromentis\Core\DAL\Query('UPDATE events_participant p SET p.status = t.waiting FROM temp_statuses t WHERE p.id = t.id');
    $r = $db->query($q);
} else
{
    $q = new \Claromentis\Core\DAL\Query("CREATE TEMPORARY TABLE IF NOT EXISTS temp_statuses AS (SELECT id, waiting FROM events_participant)");

    $r = $db->query($q);

    $db->DropColumn('events_participant', 'waiting');
    $db->AddColumn('events_participant', 'status', 'INT NOT_NULL DEFAULT 0');

    $q = new \Claromentis\Core\DAL\Query('UPDATE events_participant p, temp_statuses t SET p.status = t.waiting WHERE p.id = t.id');
    $r = $db->query($q);
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('03.01');
