<?php
$_db_migration_to = '08.01'; // 2.3.0-rc
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_google_maps_api_key.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$events_config = $migrations->GetConfigFull('events');
$key = $events_config->Get('google_maps_api_server_key');

if ($key !== null)
{
	$new_key_json = json_encode(array('api_key'=>$key));
	// check any key data that may already be in the integration table
	$result = $db->query("SELECT * FROM integration WHERE api_name = 'google_maps'");
	$entry = null;
	$entry_data = null;
	if ($result->hasData())
	{
		$entry = $result->fetchArray();
		$entry_data = json_decode($entry['json_value'], true);
	}

	if ($entry === null && $entry_data === null)
	{
		// no entry exists, create it.
		$db->query("INSERT INTO integration VALUES ('google_maps', 'Google Maps API Key', 'Created in the Google Developer console', str:key_json)", $new_key_json);
	}
	else
	{
		// check key value and update if it's the default value (all x's)
		if (!empty($entry_data['api_key']) && preg_match('/^x+$/', $entry_data['api_key']))
		{
			$db->query("UPDATE integration SET json_value = str:new_key_json WHERE api_name='google_maps'", $new_key_json);
		}
	}
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('08.01');
