<?php
// This file contains the database schema version 10.02
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
if ($migrations->GetVersion() > 0)
	throw new Exception("The database is already initialized");
//===========================================================================================

// events_attachment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'event_id'	=>	"INT NULL",
	'name'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('events_attachment', $table_descr, true);



// events_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'events_quantity'	=>	"INT NULL",
);

$db->CreateTable('events_category', $table_descr, true);



// events_event
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'category_id'	=>	"INT NULL",
	'organiser_id'	=>	"INT NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'timezone'	=>	"VARCHAR(255) NULL",
	'location'	=>	"VARCHAR(255) NULL",
	'google_map'	=>	"VARCHAR(500) NULL",
	'details'	=>	"CLOB NULL",
	'cost'	=>	"FLOAT NULL",
	'participants_limited'	=>	"BOOL NULL",
	'capacity'	=>	"INT NULL",
	'max_guest'	=>	"INT NULL",
	'max_waiting'	=>	"INT NULL",
	'in_calendar'	=>	"BOOL NULL",
	'is_sticky'	=>	"BOOL NULL",
	'send_email'	=>	"BOOL NULL",
	'date_modified'	=>	"INT_DATE NULL",
	'date_created'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'created_by'	=>	"INT NULL",
	'currency'	=>	"VARCHAR(15) NULL",
	'status'	=>	"INT NULL DEFAULT 0",
	'sequence_id'	=>	"INT NULL",
	'full_day'	=>	"INT NULL",
	'joining_details'	=>	"VARCHAR_MAX NULL",
	'qualification_code'	=>	"VARCHAR(255) NULL DEFAULT NULL",
	'has_training_record'	=>	"INT NOT_NULL DEFAULT 0",
	'approval'	=>	"INT NOT_NULL DEFAULT 0",
	'hide_participants'	=>	"BOOL NOT_NULL DEFAULT 0",
	'cover_image_width'	=>	"INT NULL",
);

$db->CreateTable('events_event', $table_descr, true);
$db->CreateIndex('events_event', 'index_sequence_id', 'sequence_id', 'date_start');



// events_participant
$table_descr = array(
	'id'	=>	"IDENTITY",
	'event_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'date_join'	=>	"INT_DATE NULL",
	'guests'	=>	"INT NULL",
	'note'	=>	"VARCHAR(255) NULL",
	'attended'	=>	"INT NULL DEFAULT 0",
	'enrolled_by'	=>	"INT NULL",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('events_participant', $table_descr, true);



// events_sequence
$table_descr = array(
	'id'	=>	"IDENTITY",
	'organiser_id'	=>	"INT NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'timezone_id'	=>	"INT NULL",
	'repetition_string'	=>	"VARCHAR(255) NULL",
	'date_modified'	=>	"INT_DATE NULL",
	'date_created'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'created_by'	=>	"INT NULL",
	'is_recurring'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('events_sequence', $table_descr, true);





//===========================================================================================
$migrations->SetVersion('10.02');
