define(['jquery'], function($){
	return function() {
		this.options = {
			zoom: 16
		};
		this.set = function(options) {
			$.extend(this.options, options);
			return this;
		};
		this.loadMap = function() {
			this.options.address = ($(this.options.addressPlace).val()) ? $(this.options.addressPlace).val() : $(this.options.addressPlace).text();
			if (this.options.address != '') {
				var $this = this;
				var googleMapsApiRequest = "//maps.googleapis.com/maps/api/geocode/json?address=" + encodeURIComponent($this.options.address) + "&key=" + google_maps_api_server_key;
				if (window.XDomainRequest) {
					xdr = new XDomainRequest();
					xdr.open("GET", googleMapsApiRequest);
					xdr.send();
					xdr.onload = function () {
						$this._showMap($.parseJSON(xdr.responseText));
					};
				} else {
					$.getJSON(
						'https:' + googleMapsApiRequest,
						function (data) {
							$this._showMap(data)
						}
					);
				}
			} else {
				if (this.options.mapPlace) $(this.options.mapPlace).hide();
			}
			return this;
		};
		this._showMap = function(data) {
			var result = data.results[0];
			if (result && result.hasOwnProperty('geometry')) {
				if (this.options.googleMapLink && result.hasOwnProperty('formatted_address'))
					$(this.options.googleMapLink).val(result.formatted_address);
				var loc = result.geometry.location;
				var mapOptions = {
					center: new google.maps.LatLng(loc.lat, loc.lng),
					zoom: this.options.zoom
				};
				var map = new google.maps.Map(document.getElementById(this.options.mapID), mapOptions);
				var marker = new google.maps.Marker({
					position: mapOptions.center,
					map: map,
					title: this.options.address
				});
				if (this.options.mapPlace) $(this.options.mapPlace).show();
			} else {
				if (this.options.mapPlace) $(this.options.mapPlace).hide();
			}
		};
		this.autocomplete = function() {
			var $this = this;
			autocomplete = new google.maps.places.Autocomplete(
				(document.getElementById('location'))
//			, { types: ['geocode'] }
			);

			google.maps.event.addListener(autocomplete, 'place_changed', function() {
				$this.loadMap();
			});

			return this;
		}
	};
});
