define(['jquery'], function($){
    return function(){
        $(".js-attended-checkbox-all").off().on("change", function() {
            var checked_all = $(this).is(":checked");
            var checkboxes = $(".attended_checkbox");
            for(var i=0; i<checkboxes.length; i++){
                if(checked_all) {
                    if (!checkboxes[i].checked) {
                        checkboxes[i].checked = true;
                    }
                }
                else{
                    if (checkboxes[i].checked) {
                        checkboxes[i].checked = false;
                    }
                }
            }
        });

        $(".js-mark-as-attended-button").on("click", function() {
            var checkboxes = $(".attended_checkbox");
            var users = []
            var training = checkboxes[0].getAttribute("data-training");
            for(var i=0; i<checkboxes.length; i++){
                var user = [];
                user.push(checkboxes[i].checked);
                user.push(checkboxes[i].getAttribute("data-id"));
                user.push(checkboxes[i].getAttribute("data-user"));
                users.push(user);
            }
            if (training !== "0") {
                var msg = lmsg("events.event_registry.this_is_training_event");
                if (window.confirm(msg)) {
                    xajax_SetAttendance(users);
                }
            } else {
                xajax_SetAttendance(users);
            }
        });

        $(".approved_dropdown").on('focus', function () {
            $(this).data('old_value', $(this).val());
        }).change(function() {
            var msg;
            var decision = $(this).val();
            var id = $(this).data("id");
            var user = $(this).data("user");

            if (decision != 2) {
                msg = decision == 0 ? lmsg("events.details.approve_users") : lmsg("events.details.decline_user");
            }

            if (msg && window.confirm(msg)) {
                xajax_SetApproval(decision, id, user);
            } else if (!msg) {
                xajax_SetApproval(decision, id, user);
            } else {
                $(this).val($(this).data('old_value'))
            }

            return false;
        });

        $(".delete-booking").off().on("click", function ()
        {
            if (window.confirm(lmsg("events.details.attendee_delete")))
            {
                var id = $(this).data("event");
                $("#delete").val(id);
                $("#page_form").submit();
            }
            return false;
        });

        $(".edit-booking").off().on("click", function ()
        {
            var id = $(this).data("event")
            xajax_PopulateEditPopup(id);
            return false;
        });


        /*var page_size = 50;
         $("#attendee_users").select2({
         placeholder: "Add a new attendee..",
         minimumInputLength: 3,
         allowClear: true,

         ajax: {
         url: "/intranet/events/user_picker_list.php",
         dataType: 'json',
         data: function (term, page) {
         return {
         keywords: term, // search term
         page_size: page_size,
         st: (page-1) * page_size
         };
         },
         results: function (data, page) {
         var more = ((page-1) * page_size) < data.total;
         return {results: data.data, more: more};
         }
         }
         });*/
    };
});

showEditPopup = function(pid, guests, max_guests, notes)
{
    $('#note').html(notes);
    $('#pid').val(pid);

    var select = $('#guest_count');
    select.html('');

    if (max_guests == 0)
        $('#max_guest_container').remove();
    else
        for (var i=0; i <= max_guests; i++)
        {
            var option = '<option value="' + i + '"';
            if (guests == i)
                option += ' selected ';
            option += '>' + i + '</option>';
            select.append(option);
        }

    $("#edit-user-attendance").modal();
};
