<?php

use Claromentis\Core\Services;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemRepository;

if (!defined('INSTALL_PROGRESS'))
	die("This file cannot be executed directly");

/** @var $installer Claromentis\Setup\SetupFacade */
if (!isset($installer))
	throw new Exception("Install options are not defined");

$admin_panel = $installer->GetAdminPanelCreator();
$admin_panel->Enable('events');

$plugins = $installer->GetPluginsRepository();
$plugins->Add('events', '\Claromentis\Events\EventsPlugin');

$menu = Services::I()->{MenuItemRepository::class};
$menu->save(new MenuItemApplication('events', 'Events', '/events/'));

$db = $installer->GetDb();
$db->query("INSERT INTO events_category (name) VALUES (str:name)", 'Default');

DBVar::Set('events_currency', 'EUR,USD,GBP');
