<?php
$_db_migration_to = '01.02';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_initial_tables.php', <<<'DB_UPDATE_FILE'
<?php

// events_event
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL",
	'category_id'	=>	"INT NULL",
	'organiser_id'	=>	"INT NULL",
	'date_start'	=>	"INT_DATE NULL",
	'date_end'	=>	"INT_DATE NULL",
	'timezone_id'	=>	"INT NULL",
	'location' => 'VARCHAR(255) NULL',
	'google_map' => 'VARCHAR(255) NULL',
	'details' => 'VARCHAR(1000) NULL',
	'cost'	=>	"FLOAT NULL",
	'participants_limited' => 'BOOL',
	'capacity' => 'INT NULL',
	'max_guest' => 'INT NULL',
	'max_waiting' => 'INT NULL',
	'in_calendar' => 'BOOL',
	'is_sticky' => 'BOOL',
	'send_email' => 'BOOL',
	'status' => 'VARCHAR(15) NULL',
	'date_modified'	=>	"INT_DATE NULL",
	'date_created'	=>	"INT_DATE NULL",
	'modified_by'	=>	"INT NULL",
	'created_by'	=>	"INT NULL",
);

$db->CreateTable('events_event', $table_descr, true);

// events_participant
$table_descr = array(
	'id'	=>	"IDENTITY",
	'event_id'	=>	"INT NULL",
	'user_id'	=>	"INT NULL",
	'status'	=>	"VARCHAR(15) NULL",
	'date_join'	=>	"INT_DATE NULL",
	'guests'	=>	"INT NULL",
);

$db->CreateTable('events_participant', $table_descr, true);

// events_attachment
$table_descr = array(
	'id'	=>	"IDENTITY",
	'event_id'	=>	"INT NULL",
	'name'	=>	"VARCHAR(100) NULL",
);

$db->CreateTable('events_attachment', $table_descr, true);

// events_category
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(100) NULL",
	'events_quantity'	=>	"INT NULL",
);

$db->CreateTable('events_category', $table_descr, true);
DB_UPDATE_FILE
);


$migrations->Run('02_add_participant_note.php', <<<'DB_UPDATE_FILE'
<?php
$db->AddColumn('events_participant', 'note', "VARCHAR(255)");
DB_UPDATE_FILE
);


$migrations->Run('03_add_waiting_flag.php', <<<'DB_UPDATE_FILE'
<?php
$db->AddColumn('events_participant', 'waiting', "INT DEFAULT 0");
DB_UPDATE_FILE
);


$migrations->Run('04_add_currency.php', <<<'DB_UPDATE_FILE'
<?php
$db->AddColumn('events_event', 'currency', "VARCHAR(15) NULL");
$db->DropColumn('events_participant', 'status'); #now it's waiting flag
DB_UPDATE_FILE
);


$migrations->Run('05_event_status.php', <<<'DB_UPDATE_FILE'
<?php
$db->DropColumn('events_event', 'status');
$db->AddColumn('events_event', 'status', "INT NULL DEFAULT 0");

DB_UPDATE_FILE
);


$migrations->Run('07_event_timezone.php', <<<'DB_UPDATE_FILE'
<?php
$db->AlterColumn('events_event', 'timezone_id', 'timezone', "VARCHAR(255) NULL");
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('01.02');
