<?php
$_db_migration_to = '11.02'; // 4.1.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('202401041130_cancellation_policy_evnt-73.php.php', <<<'DB_UPDATE_FILE'
<?php

use Claromentis\Core\DAL;

/**
 * EVNT-73 Cancellation Policy database migration
 * 
 * This migration will be responsible for adding two new columns:
 * - cancellation_type
 * - cancellation_deadline
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

/** @var \Claromentis\Setup\SetupFacade $migrations */
$logger = $migrations->getLogger();

$logger->notice("Starting migration for EVNT-73. Adding two new nullable columns: cancellation_type and cancellation_deadline");

$database = $migrations->GetDb();

try {
    $database->AddColumn('events_event', 'cancellation_type', 'INT NULL');
    $database->AddColumn('events_event', 'cancellation_deadline', 'int_date NULL');
} catch (DAL\Exceptions\TransactionException $exception) {
    $logger->error("Migration failed for EVNT-73");

    // Rethrow the exception to ensure the migration and upgrade fails
    throw $exception;
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('11.02');
