(function ($) {
    $.fn.date_period = function (options) {
        var settings = $.extend({
            single: false
        }, options);

        var methods = {
            init: function () {
                methods.initEvents.call(this);
                var el = $(this);
                methods.setPeriodVisible.call(this, el.find('.js-repeat-input').prop('checked'));
                if (settings.single) {
                    el.find('.js-not-single').hide();
                }
            },
            initEvents: function () {
                var el = $(this);
                el.find('.js-repeat-input').change(function () {
                    methods.setPeriodVisible.call(el, $(this).prop('checked'));
                });

                el.find('.js-period-type-input').change(function () {
                    if ($(this).val() == 2) {
                        methods.showWeekDays.call(el);
                    } else {
                        methods.hideWeekDays.call(el);
                    }
                });

                el.find('.js-full-day-input').change(function () {
                    methods.setTimeVisible.call(el, !$(this).prop('checked'));
                });

	            el.find('input.start-date-input').change(function(){
                    el.find('input.end-date-input').val($(this).val());
                });

                el.find('.js-repeat-input').change();
                el.find('.js-full-day-input').change();
            },
            setPeriodVisible: function (visible) {
                visible ? methods.showPeriod.call(this) : methods.hidePeriod.call(this);
            },
            showPeriod: function () {
                $(this).find('.period-row').show();
                if ($(this).find('.js-period-type-input').val() == 2) {
                    methods.showWeekDays.call(this);
                } else {
                    methods.hideWeekDays.call(this);
                }
            },
            hidePeriod: function () {
                $(this).find('.period-row').hide();
                methods.hideWeekDays.call(this)
            },
            showWeekDays: function () {
                $(this).find('.js-week-days-row').show();
            },
            hideWeekDays: function () {
                $(this).find('.js-week-days-row').hide();
            },
            setTimeVisible: function (visible) {
                if (visible) {
                    $(this).find('input.start-time-input').show();
                    $(this).find('input.end-time-input').show();
                } else {
                    $(this).find('input.start-time-input').hide();
                    $(this).find('input.end-time-input').hide();
                }
            }
        };

        return this.each(function () {
            methods.init.call(this);
        });
    }
})(jQuery);