define(['jquery', 'GoogleMaps', 'expander'],function($, GoogleMaps, Expander){
	return function(){
        $(".send-email-button").on("click", function(){
            var email_button = $(this);
            var current_url = window.location.href;
            var event_id    = current_url.split("events/")[1];
            var email_sent_at = Date.parse(localStorage.getItem("events_email_sent_at_" + event_id));
            if(email_sent_at) {
                var ms_diff = new Date() - email_sent_at;
            }
            if(!email_sent_at || ms_diff > 600000) {
                var can_join  = $(".js-can-join").text();
                var joined    = $(".js-joined").text();
                var waiting   = $(".js-waiting").text();
                var no_emails = can_join - joined - waiting;
                if(no_emails > 0) {
                    var msg = lmsg("events.details.send_email_to", no_emails);

                    if (window.confirm(msg)) {
                        email_button.prop('disabled', true);
                        $.ajax({
                            url: event_id + "/send-email-invite",
                            type: "POST",
                            success: function (data, textStatus, xhr) {
                                email_button.prop('disabled', false);
                                localStorage.setItem("events_email_sent_at_" + event_id, "" + new Date());
                                if (xhr.status === 204) {
                                    cla.showMessage(lmsg("events.details.email_queued", no_emails), "", false);
                                } else {
                                    cla.showMessage(lmsg("events.details.cannot_send_email"), "", true);
                                }
                            },
                            error: function (xhr) {
                                email_button.prop('disabled', false);
                                if (xhr.status === 403) {
                                    cla.showMessage(lmsg("events.details.no_permission_to_send_email"), "", true);
                                } else {
                                    cla.showMessage(lmsg("events.details.bad_request"), "", true);
                                }
                            }
                        });
                    }
                } else{
                    cla.showMessage(lmsg("events.details.no_attendees"), "", true);
                }
            } else{
                cla.showMessage(lmsg("events.details.cannot_send_email"), "", true);
            }
        });

		//making link from email open modal window automatically
		$(".modal.event-attendance").each(function(){
			if(window.location.href.indexOf($(this).attr("id")) != -1){
				$(this).modal('show');
			}
		});

		var gMaps = new GoogleMaps();
		gMaps.set({
			addressPlace: '#address',
			mapPlace: '#map_canvas',
			mapID: 'map_canvas',
			zoom: 16
		});
		gMaps.loadMap();

		$("#icalSingle").on('click', toggleICALURL);
		$("#icalRecurring").on('click', toggleICALURL);

		function toggleICALURL() {
			var $this = $(this);
			$this.addClass('active').siblings().removeClass('active');
			$('.js-ical-link').toggleClass('d-none');
		}

		var expander = new Expander({
			container: $('.participants-list'),
			marker: '<li></li>',
			openText: lmsg('events.details.see_all'),
			limit: 5
		});
		expander.expand();

		$('.js-register-modal').on('click', logBooking);

		function logBooking() {
			var user = $(this).data('ref') === 'user';
			if( user ) {
				$('#registerAsUser').removeClass('d-none');
			} else {
				$('#registerAsUser').addClass('d-none');
			}
		}

		var max_guests = $('#max_guests').val();
		var current_guests = $('#current_guests').val();
		var select = $('#guest_count');
		select.html('');
		if (max_guests == 0)
			$('#max_guest_container').remove();
		else
			for (var i=0; i <= max_guests; i++)
			{
				var option = '<option value="' + i + '"';
				if (current_guests == i)
					option += ' selected ';
				option += '>' + i + '</option>';
				select.append(option);
			}

		$('textarea[maxlength]').on({
			keypress: function(event) {
				var ignore = [8,9,13,33,34,35,36,37,38,39,40,46];
				var self = $(this),
					maxlength = self.attr('maxlength'),
					code = $.data(this, 'keycode');
				if (maxlength && maxlength > 0) {
					if (navigator.userAgent.toLowerCase().indexOf('firefox') > -1)
						self.val(self.val().substr(0,maxlength));
					else
						return ( self.val().length < maxlength || $.inArray(code, ignore) !== -1 );
				}
			},
			paste: function() {
				var self = $(this),
					maxlength = self.attr('maxlength');
				setTimeout(function () {
					self.val(self.val().substr(0,maxlength));
				}, 100)
			}
		});
	};

});
function base64_decode(data) {

	var b64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var o1, o2, o3, h1, h2, h3, h4, bits, i = 0, ac = 0, dec = '', tmp_arr = [];
	if (!data)
		return data;
	data += '';
	do {
		h1 = b64.indexOf(data.charAt(i++));
		h2 = b64.indexOf(data.charAt(i++));
		h3 = b64.indexOf(data.charAt(i++));
		h4 = b64.indexOf(data.charAt(i++));
		bits = h1 << 18 | h2 << 12 | h3 << 6 | h4;
		o1 = bits >> 16 & 0xff;
		o2 = bits >> 8 & 0xff;
		o3 = bits & 0xff;
		if (h3 == 64) {
			tmp_arr[ac++] = String.fromCharCode(o1);
		} else if (h4 == 64) {
			tmp_arr[ac++] = String.fromCharCode(o1, o2);
		} else {
			tmp_arr[ac++] = String.fromCharCode(o1, o2, o3);
		}
	} while (i < data.length);
	dec = tmp_arr.join('');
	return dec.replace(/\0+$/, '');
}
