// Set's character limit for use everywhere
var characterLimit = 7500;

define(['jquery', 'GoogleMaps'], function($, GoogleMaps){

	return function(){
        $(document).ready(detailsCharactersCount);

        // Updates character count on keyup or text paste
        $('.wysibb-body').first().on('keyup input', function() {
            detailsCharactersCount();
		});

        // Blocks the submission of the event dd/edit page if the details input has too many characters
        $('#edit-event').bind('submit',function(e) {
            e.preventDefault();
            var characterCount = $('.wysibb-body').first().text().length;

            if (characterCount <= characterLimit) {
                $(this)[0].submit();
            } else {
                cla.showMessage(lmsg('events.edit_single.details_too_long'), '', 1);
            }
        });

		// Check if this event has a webinar
		checkForWebinar();


		var gMaps = new GoogleMaps();
		gMaps.set({
			addressPlace: '#location',
			googleMapLink: '#googleMapLink',
			mapPlace: '#mapPlace',
			mapID: 'mapCanvas',
			zoom: 16
		});
		gMaps.loadMap();
		gMaps.autocomplete();

		$('input[name=participants_limited]').on('change', limitCapacity);

		$('input[name=allow_limit]').on('change', allowLimit);

		$('input[name=allow_waiting]').on('change', allowWaiting);

		$('#delete_event').on('click', deleteEvent);

        $("#approval_required").on('click', toggle_manager_approval_state);

		$('.cla_time_picker').on('change', checkDate);
		$('#cancellation_deadline_day').on('blur', checkCancellationDate);
		$('.date_picker').on('blur', checkDate);

		$('[name="perms_dialog"]').submit(function() {
			if ($('#location').val() == $('#location').attr('placeholder'))
				$('#location').val('');
		});

		$('#location').keypress(function(e) {
			var code = e.keyCode || e.which;
			if(code == 13) return false;
		});

		$('[name="guest_count"]').on('change', function() {
			var outer = $(this).outerWidth() - $(this).width();
			var valWidth = $(this).val().length * parseInt($(this).css('font-size'));
			var width = outer + valWidth;
			if (width < 60) width = 60;
			$(this).css('width', width+'px');
		});

		toggleCustomDeadline();
		checkCancellationDate();

		$('input[name="cancellation_type"]').on('change', function () {
			toggleCustomDeadline();
		});

		var $repetition = $('input[name="calendar_date[check][repetition]"]');
		checkCancellationOptions($repetition.is(':checked'));

		$repetition.on('change', function () {
			checkCancellationOptions(this.checked)
		});
	};
});

var picker = {
	start: {
		date: 'calendar_date[date][start_date]',
		time: 'calendar_date[time][start_time]'
	},
	end: {
		date: 'calendar_date[date][end_date]',
		time: 'calendar_date[time][end_time]'
	}
};


function detailsCharactersCount() {
    var characterCount = $('.wysibb-body').first().text().length;
    var countWrapper = $('.count-wrapper');
    var currentCount = $('.current');

    // Displays the current character count
    currentCount.text(characterCount);

    // Changes the color of the character count text to red if it exceeds the character limit
    if (characterCount > characterLimit) {
        countWrapper.addClass('text-danger');
        countWrapper.removeClass('text-muted');
    } else {
        countWrapper.removeClass('text-danger');
        countWrapper.addClass('text-muted');
    }
}

function deleteEvent() {
	if ( confirm(lmsg('events.edit_single.remove_event_confirm')) ) {
		$('input[name=delete]').val(1);
		$('form[name=perms_dialog]').submit();
		return;
	}

	return false;
}

function allowLimit() {
	var max_guest = $('input[name=max_guest]');

	if ($(this).is(':checked')) {
		max_guest.prop('disabled', false).focus();
	} else {
		max_guest.val('').prop('disabled', true);
	}
}

function allowWaiting() {
	var max_waiting = $('input[name=max_waiting]');
	if ($(this).is(':checked')) {
		max_waiting.prop('disabled', false).focus();
	} else {
		max_waiting.val('').prop('disabled', true);
	}
}

function limitCapacity() {
	var isLimited = $(this).val() == 1;
	$('#capacity_container').toggle(isLimited);
}

function checkDateRegExp(elem) {
	var date_str = $('[name="'+elem.date+'"]').val(),
		time_str = $('[name="'+elem.time+'"]').val();

	return parse_date_to_object(date_str, time_str);
}

function checkDate() {
	var startDate = checkDateRegExp(picker.start),
		endDate = checkDateRegExp(picker.end),
		now = new Date($.now()),
		dateInPast = (startDate < now || endDate < now);

	$('#dateIsPast').toggleClass('d-none', !dateInPast);
	$('#sequenceIsPast').toggleClass('d-none', !dateInPast);

	if($('input[name="calendar_date[check][repetition]"]').is(':checked')) {
		$('#dateIsPast').hide();
		$('#sequenceIsPast').show();

	} else {
		$('#sequenceIsPast').hide();
		$('#dateIsPast').show();
	}
}


function toggleCustomDeadline(selected) {

	if (selected === undefined) {
		selected = $('input[name="cancellation_type"]:checked').val();
	}

	var sections = {
		'0': '#cancellation_anytime',
		'1': '#cancellation_none',
		'2': '#cancellation_custom'
	};

	$(Object.values(sections).join(',')).hide();

	// Show only the relevant one
	if (sections[selected]) {
		$(sections[selected]).show();
	}
}

function checkCancellationDate() {
	var cancellationDate = parse_date_to_object($('[name="cancellation_deadline_day"]').val(), '00:00');
	cancellationDate.setHours(0, 0, 0, 0);

	var dateNow = new Date();
	dateNow.setHours(0, 0, 0, 0);

	var dateInPast = cancellationDate < dateNow;

	var $cancellationDateWarning = $('.js-cancellation-custom-warning');

	if (dateInPast) {
		$cancellationDateWarning.show();
	} else {
		$cancellationDateWarning.hide();
	}
}

function checkCancellationOptions(checked) {
	var $custom = $('#custom').parent();
	var $anytime = $('#anytime');

	if (checked) {
		// 2 is "custom"
		if ($('input[name="cancellation_type"]:checked').val() === "2") {
			$anytime.trigger('click');
			toggleCustomDeadline('anytime');
		}
		$custom.hide();
	} else {
		$custom.show();
	}
}

function checkForWebinar(){
	// bind change event for the webinar checkbox
	$('#webinar').on('change', toggleWebinar);

	// check data-webinar attrib to control visiblity of the element
	var isWebinar = $('#webinar').is(":checked");
	$('.js-webinar').each(function(){
		var show = isWebinar !== $(this).data('webinar');
		$(this).toggleClass('d-none', show);
	});
}

function toggle_manager_approval_state() {
    var manager_approval_checkbox = $("#approval_manager");
    if($("#approval_required").prop('checked')){
        manager_approval_checkbox.prop('disabled', false);
    } else {
        manager_approval_checkbox.prop('checked', false);
        manager_approval_checkbox.prop('disabled', true);
    }
}

function remove_event_attachment(id) {
	$(id).remove();
}

function toggleWebinar(){
	$('.js-webinar').toggleClass('d-none');
}
