define(['jquery'], function($){
	return function(){
		var events = events || {};

		events.showArgs = {
			limit: 5,
			offset: 5,
			noMore: false
		};

		events.search_type = function (elem) {
			var type = $(elem).data('type');
			$('input[name=type]').val(type);
			events.search();
		};

		events.search_order = function(elem){
			var order = $(elem).data('search-order');
			$('input[name=order]').val(order);
			events.search();
		};

		events.search_category = function(elem){
			var cat_id = $(elem).attr('id').substring(4);
			$('input[name=category]').val(cat_id);
			events.search();
		};

		events.search = function(){
			$('#event_search').submit();
		};

		events.resetForm = function(){
			$('#keywords').val('');
			events.search();
		};

		events.hideShowMore = function(){
			$("#showMore").hide();
		};

		events.load = function(){
			if(events.showArgs.noMore) {
				events.hideShowMore();
				return false;
			}

			$.ajax({
				type: "GET",
				url: $(location).attr('href'),
				// url : "/intranet/foo/",
				data: events.showArgs,
				dataType: 'JSON',
				success: function(data) {
					events.showArgs.offset += events.showArgs.limit;

					$(data).each(function() {
						var t= _.template( $( "#event-prototype" ).html())( this );
						$('.js-events-list-place').append(t);
					});
					if (data.length == 0 || data.length < events.showArgs.limit || events.showArgs.offset >= eventsCnt) {
						events.showArgs.noMore = true;
						events.hideShowMore();
					}
					return true;
				},
				error: function (xhr, status, error) {
					var err = $('<div class="alert alert-error"/>');
					err.html(error);
					$('.js-events-list-place').append(err);
				}
			});
		};

		// controls for recurring other dates panel
		events.otherDates = {};

		events.otherDates.toggleShowDates = function(e) {
			var target = e.data;
			var $target = $(target);

			if (!e.data) {
				target = e.currentTarget;
				$target = $(target).parents(".js-event-item");
			}

			var menuState = !$target.data('dates-shown');
			var eventname = menuState ? 'showDates' : 'hideDates';

			$target
				.data('dates-shown', menuState)
				.toggleClass('active', menuState);

			// Check for user clicking a link, otherwise return false;
			if((e.srcElement && e.srcElement.tagName === 'A' && !menuState) || e.data) {
				return;
			}

			$('.js-event-item.active').not($target).find('.js-more-dates').click();

			$target.trigger(eventname);

			return false;
		};

		events.otherDates.escape = function(e){
			if(e.keyCode === 27) {
				events.otherDates.toggleShowDates(e.data);
			}
		};

		$('.js-events-list').on('showDates', '.js-event-item', function(e){
			$('body')
				.on('click', e.currentTarget, events.otherDates.toggleShowDates)
				.on('keyup', e, events.otherDates.escape);
		});

		$('.js-events-list').on('hideDates', '.js-event-item', function(){
			$('body').unbind('click keyup');
		});

		events.showArgs.offset = $('.js-events-list-place').children().length;

		// hide show more button if number of events is limited
		if (events.showArgs.offset >= eventsCnt) {
			events.hideShowMore();
		}

		// override template placeholders to use mustache style
		_.templateSettings = {
			evaluate    : /\{\{([\s\S]+?)\}\}/g,
			interpolate : /\{\{=([\s\S]+?)\}\}/g,
			escape      : /\{\{-([\s\S]+?)\}\}/g
		};

		// event binding

		/* // removed js handler for filtering
		 // search by event type
		 $('a[data-type]').on('click', function(event){
		 event.preventDefault();
		 events.search_type(this);
		 });

		 // search by event category
		 $('.categories-list').on('click', 'a', function (event) {
		 event.preventDefault();
		 events.search_category(this);
		 });

		 // update search order
		 $('a[data-search-order]').on('click', function(event){
		 event.preventDefault();
		 events.search_order(this);
		 });
		 */

		// reset form button
		$('#reset').on('click', events.resetForm);

		// load more events
		$("#showMore").on('click', events.load);

		// show more/less dates
		$('.js-events-list').on('click', '.js-more-dates, .js-less-dates', events.otherDates.toggleShowDates);
		// $('.js-show-less').on('click', events.otherDates.showLess);
	};
});
