define(['jquery'], function($){
	return function(options) {

		this.mainOptions = {
			limit: 10,
			marker: '<span></span>',
			openText: lmsg('events.expander.show_more'),
			link: '<a class="show-more-link" href="javascript:void(0);">$openText</a>'
		};
		this.resource = {
			list: {visible: [], hidden: []}
		};
		this.expand = function() {
			var $this = this;
			$.extend($this.mainOptions, options);
			if (!$this.mainOptions.container || $this.mainOptions.container.children().length <= $this.mainOptions.limit)
				return false;
			$this.mainOptions.container.children().each(function(i, elem) {
				if (i < $this.mainOptions.limit) {
					$this.resource.list.visible.push(elem);
				} else {
					$this.resource.list.hidden.push(elem);
					$(elem).hide(); $(elem).remove();
				}
			});
			var openLink = $($this.mainOptions.link.replace('$openText', $this.mainOptions.openText));
			var marker = $($this.mainOptions.marker).append(openLink).addClass('show-more-place');
			openLink.bind('click', function() {
				$this.mainOptions.container.append($this.resource.list.hidden);
				$($this.resource.list.hidden).each(function() { $(this).show('fast'); });
				marker.remove();
			});
			$this.mainOptions.container.append(marker);
		};

	};
});

