define([], function () {

    /**
     * Undo/Save object
     * @class Undo
     * @constructor
     * @property {Array} history - array of actions performed since last save.
     */
    var Undo = function () {
        this.model = new Undo.Model();
        this.view = new Undo.View();
    };

    Undo.Model = function () {
        this.view = null;
        /**
         * Array of actions
         * @private
         * @type {Array}
         */
        this.history = [];
    };

    Undo.Model.prototype = (function () {
        var setView = function (view) {
            this.view = view;
        };
        /**
         * Revert the last item in the history array
         * @private
         * @memberOf Undo
         * @returns {Object} Undo
         */
        var addHistory = function (obj) {
            this.history.push(obj);
            //console.log(this);
            this.controller.view.toggleVisibility();
            return this;
        };

        /**
         * @private
         * @memberOf Undo
         * @param {Object} revert - action to undo
         */
        var undoAddRule = function (revert) {
            //console.log(revert);
        };

        /**
         * @private
         * @memberOf Undo
         * @param {Object} revert - action to undo
         */
        var undoDeleteRule = function (revert) {
            //console.log(revert);
        };

        /**
         * Undo last actioon in history
         * @private
         * @memberOf Undo
         */
        var undo = function () {
            if (Instance.Undo.model.history.length > 0) {
                var revert = Instance.Undo.history.pop();
                switch (revert.action) {
                    case 'add-rule' :
                        undoAddRule(revert);
                        break;
                    case 'delete-rule' :
                        undoDeleteRule(revert);
                        break;
                }
            }
            toggleVisibility();
            Instance.Fields.view.render();
        };

        /**
         * Save all actions in history
         * @private
         * @memberOf Undo
         */
        var save = function () {
            while (Instance.Undo.model.history.length > 0) {
                var sync = Instance.Undo.history.shift();
                switch (sync.action) {
                    case 'add-rule' :
                        xajax_rule_add(sync.fieldSymName, projectId);
                        break;
                    case 'delete-rule' :
                        //console.log(sync);
                        //xajax_rule_delete(sync.ruleId, sync.fieldSymName, projectId);
                        break;
                }
            }
            toggleVisibility();
        };

        return {
            setView: setView,
            /**
             * Add an action to the history array
             * @public
             * @memberOf Undo
             */
            addHistory: addHistory,

            /**
             * Undo the last action
             * @public
             * @memberOf Undo
             */
            undo: undo,

            /**
             * Save all actions using XAJAX
             * @public
             * @memberOf Undo
             */
            save: save
        };
    })();

    Undo.View = function () {
        this.model = null;
    };

    Undo.View.prototype = (function () {

        var setModel = function (model) {
            this.model = model;
        };

        /**
         * Toggle the save and undo buttons
         * @private
         * @memberOf Undo
         * @returns {Object} Undo
         */
        var toggleVisibility = function () {
            var undoButton = $('#undo');
            var saveButton = $('#save');
            if (Instance.Undo.model.history.length > 0) {
                undoButton.fadeIn();
                saveButton.fadeIn();
            } else {
                undoButton.fadeOut();
                saveButton.fadeOut();
            }
            return this;
        };

        return {
            setModel: setModel,

            /**
             * Initialise object
             * @public
             * @memberOf Undo
             */
            init: function () {
                $('#undo').on('click', this.undo);
                $('#save').on('click', this.save);
            },

            toggleVisibility: toggleVisibility
        };
    })();

    return Undo;
});