<?php
$_db_migration_to = '25.06'; // 7.4.2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_people_search_fields.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */

$db = $migrations->GetDb();
$db->AddColumn('users_fields', 'advanced_search_order', 'INT DEFAULT -1');
$db->query("UPDATE users_fields SET advanced_search_order=view_profile_order");

DB_UPDATE_FILE
);


$migrations->Run('02_people_search_add_standard.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$add_field = function ($name) use ($db)
{
	list($exists) = $db->query_row('SELECT COUNT(1) FROM users_fields WHERE advanced_search_order<>-1 AND field_name eq:str:name', $name);
	if (!$exists)
		$db->query("UPDATE users_fields SET advanced_search_order=advanced_search_order+1 WHERE advanced_search_order<>-1 OR field_name eq:str:name", $name);
};

$fields_to_add = array_reverse(array(
	'firstname',
	'surname',
	'job_title',
	'company',
	'role',
	'group',
	'ex_area_id',
));

foreach ($fields_to_add as $f)
{
	$add_field($f);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('25.06');
