<?php
namespace Claromentis\People;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array("_62d701c3c53404" . "f06345eb35720a4" . "7b4" => base64_decode("aXNfb" . "nVtZX" . "JpYw=" . "="), "_d706c16" . "0e45bf74" . "34fff82a" . "5976f0e1" . "9" => base64_decode("YXJyYX" . "lfa2V5" . "cw=="), "_31767d7ad58e706db" . "f47b7a51a0fe6c4" => base64_decode("Y291" . "bnQ="), "_075c6c4172ea" . "f58cfa84828a3" . "582d19a" => base64_decode("YXJyYXlfdW5pc" . "XVl"), "_f73dab606630b388" . "645c4f7d3fbb13bb" => base64_decode("YXJyYXl" . "fbWVyZ2" . "U="), "i" . "d" => base64_decode("a" . "W" . "Q" . "="), "_b10579d5306e" . "5a3556f94720a" . "7723353" => base64_decode("cGVvcG" . "xl"), "_ea8229a121285ee649a72fd8" . "80bac39b" => base64_decode("YXJyYXlfZmlsdG" . "Vy"), "_4bce3a08782de108" . "b3737e94bd8e2956" => base64_decode("cGFzc3dvcmRfcm" . "VzZXQ="), "_5e30c4717ced36c" . "ff9e93e19a5c576c" . "c" => base64_decode("aXNfc3Rya" . "W5n"), "_ebff9d37a7bb577c57bee4" . "dd9f0e5fd7" => base64_decode("YXJy" . "YXlf" . "dmFs" . "dWVz"), "_9c026414b414ba0d6482b28b72633" . "b57" => base64_decode("U0FBUw=" . "="), "_bd71c3b5c201fc11db82ed14c" . "e424de5" => base64_decode("aW5fYX" . "JyYXk="), "_680cc2b8220e94c8c32b8bc7c6" . "5519b4" => base64_decode("aXNfaW" . "50"), "_4493030a" . "fc686b46b" . "0427435b4" . "e366fe" => base64_decode("Q0xBUk9f" . "U1lTVEVN" . "X01PREU="), "_9a2ef4ae6a574" . "5ffe5fac33c88a" . "222fa" => base64_decode("ZXh0cmFuZ" . "XQ="));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\Acl\Simple\SimpleAclRepository;
use Claromentis\Core\Config\Config;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Entity\Extranet;
use Claromentis\People\Entity\Group;
use Claromentis\People\Entity\Role;
use Claromentis\People\Entity\User;
use Claromentis\People\Filter\GroupFilter;
use Claromentis\People\Repository\ExtranetRepository;
use Claromentis\People\Repository\GroupRepository;
use Claromentis\People\Repository\RoleRepository;
use Claromentis\People\Repository\UserRepository;












class PeopleAcl
{
    
    
    
    
    
    
    const CLASS_POWER_USER = 46;
    
    
    
    
    
    
    const VIEW_USERS = PERM_EDIT;
    
    
    
    
    
    
    
    const EDIT_USERS = PERM_EDIT_MODERATE;
    
    
    
    
    
    
    
    const ASSIGN_TO = PERM_EDIT_PERMS;
    
    
    
    
    
    
    const EDIT = PERM_DELETE;
    
    
    
    
    
    
    
    
    const POWER_USER_FLAGS = [self::CREATE_USERS, self::CREATE_ROLES, self::CREATE_GROUPS];
    
    
    
    
    
    
    
    
    
    
    const CREATE_USERS = 'usr_power_add_users';
    
    
    
    
    
    
    
    
    const CREATE_ROLES = 'usr_power_add_roles';
    
    
    
    
    
    
    
    
    const CREATE_GROUPS = 'usr_power_add_groups';
    
    
    
    
    
    
    
    
    
    const NOTIFY_ADMINS = 'usr_power_notify_peopleadmins';
    
    
    
    
    const GUEST_FIELDS = ['firstname', 'surname', 'fullname', 'job_title', 'photo_url', 'extranet_id', 'extranet', 'extranet_url', 'groups_url', 'roles_url'];
    
    
    
    
    
    
    
    
    protected $config;
    
    
    
    
    
    
    
    
    protected $acl_repository;
    
    
    
    
    
    
    
    
    protected $simple_acl_repository;
    
    
    
    
    
    
    
    
    protected $power_user_flags;
    
    
    
    
    protected $group_repository;
    
    
    
    
    protected $role_repository;
    
    
    
    
    protected $user_repository;
    
    
    
    
    protected $extranet_repository;
    
    
    
    
    protected $fields_acl_repository;
    
    
    
    
    protected $profile_field_view_acls;
    
    
    
    
    protected $profile_field_edit_acls;
    
    
    
    
    protected $fields_config;
    
    
    
    
    protected $name_transformer;
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function __construct(Config $config, AclRepository $_ecd42e37de77b33f13a2c4d09f59d78f, SimpleAclRepository $_d5b9863daa467326d881d3270322e524, GroupRepository $_efe123fd19d21a3a78376b566dad7284, RoleRepository $_90f6cb30a269a622b4c838bfd5a0a5db, UserRepository $_eeeeb0d673b7b0fd0bdca58b5541c3e0, ExtranetRepository $_4af3095f20a1f91b94a8762557924437, UserFieldsAclRepository $_1d2099c04822b9c33b19b8fa2b19021d, UserFieldsConfigService $_f7f0e26958c78ac23ccbd2b722bcc616, UserFieldsNameTransformer $_ced9d00a7550c44b6a60a6ad4b8e208d)
    {
        $this->config = $config;
        $this->acl_repository = $_ecd42e37de77b33f13a2c4d09f59d78f;
        $this->simple_acl_repository = $_d5b9863daa467326d881d3270322e524;
        $this->group_repository = $_efe123fd19d21a3a78376b566dad7284;
        $this->role_repository = $_90f6cb30a269a622b4c838bfd5a0a5db;
        $this->user_repository = $_eeeeb0d673b7b0fd0bdca58b5541c3e0;
        $this->extranet_repository = $_4af3095f20a1f91b94a8762557924437;
        $this->fields_acl_repository = $_1d2099c04822b9c33b19b8fa2b19021d;
        $this->fields_config = $_f7f0e26958c78ac23ccbd2b722bcc616;
        $this->name_transformer = $_ced9d00a7550c44b6a60a6ad4b8e208d;
    }
    
    
    
    
    
    
    
    
    
    public function IsPeopleAdmin(SecurityContext $context) : bool
    {
        return $this->simple_acl_repository->IsGranted($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_b10579d5306e5a3556f94720a772335" . "3"], $context->GetUserId());
    }
    public function IsExtranetAdmin(SecurityContext $context) : bool
    {
        return $this->simple_acl_repository->IsGranted($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_9a2ef4ae6a5745ffe5fac33c" . "88a222fa"], $context->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function IsPowerUser(SecurityContext $context) : bool
    {
        
        
        if ($this->HasAnyPowerUserFlag($context)) {
            return true;
        }
        
        
        $acl = $this->GetPowerUserAcl($context);
        return !empty($acl->AsTextStrings());
    }
    
    
    
    
    
    
    
    
    public function CanViewUser(SecurityContext $context, $_24e0e36600d6af77406a44bb618a6253)
    {
        $_24e0e36600d6af77406a44bb618a6253 = $this->GetUser($_24e0e36600d6af77406a44bb618a6253);
        if (!$_24e0e36600d6af77406a44bb618a6253) {
            return false;
        }
        return $_24e0e36600d6af77406a44bb618a6253->isActive() && $this->CanViewExtranet($context, $_24e0e36600d6af77406a44bb618a6253->extranet_id);
    }
    
    
    
    
    
    
    
    
    public function CanViewUserAsAdmin(SecurityContext $context, $_24e0e36600d6af77406a44bb618a6253)
    {
        $_24e0e36600d6af77406a44bb618a6253 = $this->GetUser($_24e0e36600d6af77406a44bb618a6253);
        if (!$_24e0e36600d6af77406a44bb618a6253) {
            return false;
        }
        
        
        if ($this->IsPeopleAdmin($context)) {
            return true;
        }
        
        
        if ($this->IsPowerUser($context)) {
            $acl = $this->GetPowerUserAcl($context);
            $_ac28a0119009e23ea788d6c83912cde1 = SecurityContext::CreateForUser($_24e0e36600d6af77406a44bb618a6253->id);
            if ($acl->Permits($_ac28a0119009e23ea788d6c83912cde1, self::VIEW_USERS)) {
                return true;
            }
        }
        
        
        
        return false;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function CanViewUserProfileField(SecurityContext $context, string $_66dc8b21e839a9a4739443a621ecc45a) : bool
    {
        
        
        if ($context->GetUserId() === 0 && !$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_bd71c3b5c201fc11db82ed14ce424de" . "5"]($_66dc8b21e839a9a4739443a621ecc45a, self::GUEST_FIELDS)) {
            return false;
        }
        if ($_66dc8b21e839a9a4739443a621ecc45a === $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_4bce3a08782de108b3737e9" . "4bd8e2956"]) {
            return $this->IsPeopleAdmin($context);
        }
        if ($this->fields_acl_repository->HasAdvancedViewPerms($_66dc8b21e839a9a4739443a621ecc45a)) {
            return false;
        }
        $_6bee501c49427dad88c8e53168963259 = $this->fields_acl_repository->GetViewAcls($_66dc8b21e839a9a4739443a621ecc45a);
        if (!$_6bee501c49427dad88c8e53168963259) {
            return true;
        }
        foreach ($_6bee501c49427dad88c8e53168963259 as $acl) {
            if ($acl->Permits($context, PERM_VIEW)) {
                return true;
            }
        }
        return false;
    }
    public function FilterProfileFieldsForView(SecurityContext $context, array $_40283465f00ffd3ab92ea5af2f2b3559) : array
    {
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_ea8229a" . "121285ee" . "649a72fd" . "880bac39" . "b"]($_40283465f00ffd3ab92ea5af2f2b3559, function ($_66dc8b21e839a9a4739443a621ecc45a) use($context) {
            return $this->CanViewUserProfileField($context, $_66dc8b21e839a9a4739443a621ecc45a);
        });
    }
    
    
    
    
    
    
    
    
    
    
    
    public function CanEditUserProfileField(SecurityContext $context, string $_66dc8b21e839a9a4739443a621ecc45a) : bool
    {
        if ($this->fields_acl_repository->HasAdvancedEditPerms($_66dc8b21e839a9a4739443a621ecc45a)) {
            return false;
        }
        $_6bee501c49427dad88c8e53168963259 = $this->fields_acl_repository->GetEditAcls($_66dc8b21e839a9a4739443a621ecc45a);
        if (!$_6bee501c49427dad88c8e53168963259) {
            return true;
        }
        foreach ($_6bee501c49427dad88c8e53168963259 as $acl) {
            if ($acl->Permits($context, PERM_VIEW)) {
                
                
                return true;
            }
        }
        return false;
    }
    
    
    
    
    
    
    
    
    public function FilterProfileFieldsForEdit(SecurityContext $context, array $_40283465f00ffd3ab92ea5af2f2b3559) : array
    {
        return $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_ea8229a1212" . "85ee649a72fd" . "880bac39b"]($_40283465f00ffd3ab92ea5af2f2b3559, function ($_66dc8b21e839a9a4739443a621ecc45a) use($context) {
            return $this->CanEditUserProfileField($context, $_66dc8b21e839a9a4739443a621ecc45a);
        });
    }
    public function CanEditOwnUserProfileField(SecurityContext $context, string $_66dc8b21e839a9a4739443a621ecc45a) : bool
    {
        if (!$this->CanEditUserProfileField($context, $_66dc8b21e839a9a4739443a621ecc45a)) {
            return false;
        }
        $fields = $this->fields_config->GetFieldsMyProfile(true);
        $_ba9c6946533b6de00d64e93a414b4a67 = $this->name_transformer->toLegacy($_66dc8b21e839a9a4739443a621ecc45a);
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_bd71c3b5c20" . "1fc11db82ed1" . "4ce424de5"]($_ba9c6946533b6de00d64e93a414b4a67, $fields);
    }
    
    
    
    
    
    
    
    public function CanCreateUser(SecurityContext $context)
    {
        return $this->IsPeopleAdmin($context) || $this->HasPowerUserFlag($context, self::CREATE_USERS) && !empty($this->GetAssignExtranets($context));
    }
    
    
    
    
    
    
    
    
    public function CanCreateExtranetUser(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa)
    {
        return $this->CanCreateUser($context) && $this->CanAssignExtranetUsers($context, $_9a2ef4ae6a5745ffe5fac33c88a222fa);
    }
    
    
    
    
    
    
    
    
    public function CanUpdateUser(SecurityContext $context, $_24e0e36600d6af77406a44bb618a6253) : bool
    {
        $user_id = $this->GetId($_24e0e36600d6af77406a44bb618a6253);
        
        
        $_812ee0306e97841dbab44d6b6ecd56aa = $this->config->get($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4493030af" . "c686b46b04" . "27435b4e36" . "6fe"]);
        if ($_812ee0306e97841dbab44d6b6ecd56aa === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_9c026414b414ba0d648" . "2b28b72633b57"] && $user_id === 1) {
            return $context->GetUserId() === $user_id;
        }
        if ($this->IsPeopleAdmin($context)) {
            return true;
        }
        if (!$user_id) {
            return $this->CanCreateUser($context);
        }
        if ($this->IsPowerUser($context)) {
            $acl = $this->GetPowerUserAcl($context);
            $_ac28a0119009e23ea788d6c83912cde1 = SecurityContext::CreateForUser($user_id);
            if ($acl->Permits($_ac28a0119009e23ea788d6c83912cde1, self::EDIT_USERS)) {
                return true;
            }
        }
        return false;
    }
    
    
    
    
    
    
    
    
    public function CanDeleteUser(SecurityContext $context, $_24e0e36600d6af77406a44bb618a6253)
    {
        if ($this->GetId($_24e0e36600d6af77406a44bb618a6253) === 1) {
            return false;
        }
        return $this->CanUpdateUser($context, $_24e0e36600d6af77406a44bb618a6253);
    }
    
    
    
    
    
    
    
    
    public function CanViewGroup(SecurityContext $context, $_e9208e4fb555ac989f7519e19c1da810)
    {
        $_e9208e4fb555ac989f7519e19c1da810 = $this->GetGroup($_e9208e4fb555ac989f7519e19c1da810);
        if (!$_e9208e4fb555ac989f7519e19c1da810) {
            return false;
        }
        return $context->IsPrimaryExtranet() || $this->CanBelongToGroup($context, $_e9208e4fb555ac989f7519e19c1da810) || $this->CanViewExtranetAsAdmin($context, $_e9208e4fb555ac989f7519e19c1da810->extranet_id);
    }
    
    
    
    
    
    
    
    
    public function CanBelongToGroup(SecurityContext $context, $_e9208e4fb555ac989f7519e19c1da810)
    {
        $_e9208e4fb555ac989f7519e19c1da810 = $this->GetGroup($_e9208e4fb555ac989f7519e19c1da810);
        if (!$_e9208e4fb555ac989f7519e19c1da810) {
            return false;
        }
        if (!$_e9208e4fb555ac989f7519e19c1da810->extranet_id) {
            return true;
        }
        return $context->GetExtranetAreaId() === $_e9208e4fb555ac989f7519e19c1da810->extranet_id;
    }
    
    
    
    
    
    
    
    public function CanCreateGroup(SecurityContext $context) : bool
    {
        return $this->IsPeopleAdmin($context) || $this->HasPowerUserFlag($context, self::CREATE_GROUPS);
    }
    
    
    
    
    
    
    
    
    public function CanUpdateGroup(SecurityContext $context, $_e9208e4fb555ac989f7519e19c1da810) : bool
    {
        $group_id = $this->GetId($_e9208e4fb555ac989f7519e19c1da810);
        if (!$group_id) {
            return $this->CanCreateGroup($context);
        }
        return $this->IsPeopleAdmin($context) || $this->CheckGroupsTree($context, self::EDIT, $group_id);
    }
    
    
    
    
    
    
    
    
    public function CanDeleteGroup(SecurityContext $context, $_e9208e4fb555ac989f7519e19c1da810) : bool
    {
        return $this->CanUpdateGroup($context, $_e9208e4fb555ac989f7519e19c1da810);
    }
    
    
    
    
    
    
    
    
    
    public function CanAssignGroups(SecurityContext $context) : bool
    {
        return !empty($this->GetAssignGroups($context));
    }
    
    
    
    
    
    
    
    
    public function CanAssignGroupUsers(SecurityContext $context, $_e9208e4fb555ac989f7519e19c1da810) : bool
    {
        $group_id = $this->GetId($_e9208e4fb555ac989f7519e19c1da810);
        if (!$group_id) {
            return $this->CanCreateGroup($context);
        }
        return $this->IsPeopleAdmin($context) || $this->CheckGroupsTree($context, self::ASSIGN_TO, $group_id);
    }
    
    
    
    
    
    
    
    
    
    public function GetAssignGroups(SecurityContext $context)
    {
        if ($this->IsPeopleAdmin($context)) {
            return $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_ebff9d37a7bb577c57bee4dd9f0e5f" . "d7"]($this->group_repository->all()->pluck($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["i" . "d"])->toArray());
        }
        return $this->GetPowerUserAcl($context)->GetOwnersList(self::ASSIGN_TO, PermOClass::GROUPTREE);
    }
    
    
    
    
    
    
    
    
    public function CanViewRole(SecurityContext $context, $_d1071a032215f0eb5c4a8ef175f7049d)
    {
        return $this->CanBelongToRole($context, $_d1071a032215f0eb5c4a8ef175f7049d) || $this->CanViewExtranetAsAdmin($context, $_d1071a032215f0eb5c4a8ef175f7049d->extranet_id);
    }
    
    
    
    
    
    
    
    
    public function CanBelongToRole(SecurityContext $context, $_d1071a032215f0eb5c4a8ef175f7049d)
    {
        $_d1071a032215f0eb5c4a8ef175f7049d = $this->GetRole($_d1071a032215f0eb5c4a8ef175f7049d);
        if (!$_d1071a032215f0eb5c4a8ef175f7049d) {
            return false;
        }
        if (!$_d1071a032215f0eb5c4a8ef175f7049d->extranet_id) {
            return true;
        }
        return $this->CanViewExtranet($context, $_d1071a032215f0eb5c4a8ef175f7049d->extranet_id);
    }
    
    
    
    
    
    
    
    public function CanCreateRole(SecurityContext $context) : bool
    {
        return $this->IsPeopleAdmin($context) || $this->HasPowerUserFlag($context, self::CREATE_ROLES);
    }
    
    
    
    
    
    
    
    
    public function CanUpdateRole(SecurityContext $context, $_d1071a032215f0eb5c4a8ef175f7049d) : bool
    {
        $role_id = $this->GetId($_d1071a032215f0eb5c4a8ef175f7049d);
        if (!$role_id) {
            return $this->CanCreateRole($context);
        }
        return $this->IsPeopleAdmin($context) || $this->GetPowerUserAcl($context)->Has(self::EDIT, PermOClass::ROLE, $role_id);
    }
    
    
    
    
    
    
    
    
    public function CanDeleteRole(SecurityContext $context, $_d1071a032215f0eb5c4a8ef175f7049d) : bool
    {
        return $this->CanUpdateRole($context, $_d1071a032215f0eb5c4a8ef175f7049d);
    }
    
    
    
    
    
    
    
    
    
    public function CanAssignRoles(SecurityContext $context) : bool
    {
        return !empty($this->GetAssignRoles($context));
    }
    
    
    
    
    
    
    
    
    public function CanAssignRoleUsers(SecurityContext $context, $_d1071a032215f0eb5c4a8ef175f7049d) : bool
    {
        $role_id = $this->GetId($_d1071a032215f0eb5c4a8ef175f7049d);
        if (!$role_id) {
            return $this->CanCreateRole($context);
        }
        return $this->IsPeopleAdmin($context) || $this->GetPowerUserAcl($context)->Has(self::ASSIGN_TO, PermOClass::ROLE, $role_id);
    }
    
    
    
    
    
    
    
    
    
    public function GetAssignRoles(SecurityContext $context)
    {
        if ($this->IsPeopleAdmin($context)) {
            return $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_ebff9d37a7bb577c57bee4dd9f0e" . "5fd7"]($this->role_repository->all()->pluck($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["i" . "d"])->toArray());
        }
        return $this->GetPowerUserAcl($context)->GetOwnersList(self::ASSIGN_TO, PermOClass::ROLE);
    }
    
    
    
    
    
    
    
    
    public function CanViewExtranet(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa) : bool
    {
        $extranet_id = $this->GetId($_9a2ef4ae6a5745ffe5fac33c88a222fa);
        $_a50b89f7a699cedab7cc721b2e6008e5 = $this->extranet_repository->getPrimaryExtranet()->id;
        return $context->IsPrimaryExtranet() || $extranet_id === $_a50b89f7a699cedab7cc721b2e6008e5 || $context->GetExtranetAreaId() === $extranet_id;
        
        
    }
    
    
    
    
    
    
    
    
    public function CanViewExtranetAsAdmin(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa) : bool
    {
        return $this->IsPeopleAdmin($context) || $this->CanUpdateExtranet($context, $_9a2ef4ae6a5745ffe5fac33c88a222fa) || $this->CanAssignExtranetUsers($context, $_9a2ef4ae6a5745ffe5fac33c88a222fa);
    }
    
    
    
    
    
    
    
    public function CanCreateExtranet(SecurityContext $context) : bool
    {
        return $this->IsPeopleAdmin($context) || $this->IsExtranetAdmin($context);
    }
    
    
    
    
    
    
    
    
    public function CanUpdateExtranet(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa) : bool
    {
        return $this->IsPeopleAdmin($context) || $this->IsExtranetAdmin($context);
    }
    
    
    
    
    
    
    
    
    public function CanDeleteExtranet(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa) : bool
    {
        return $this->CanUpdateExtranet($context, $_9a2ef4ae6a5745ffe5fac33c88a222fa);
    }
    
    
    
    
    
    
    
    
    public function CanAssignExtranetUsers(SecurityContext $context, $_9a2ef4ae6a5745ffe5fac33c88a222fa)
    {
        $extranet_id = $this->GetId($_9a2ef4ae6a5745ffe5fac33c88a222fa);
        if (!$extranet_id) {
            return $this->CanCreateExtranet($context);
        }
        return $this->IsPeopleAdmin($context) || $this->IsExtranetAdmin($context) || $this->GetPowerUserAcl($context)->Has(self::ASSIGN_TO, PermOClass::EXTRANET, $extranet_id);
    }
    
    
    
    
    
    
    
    
    public function CanAssignUserExtranetArea(SecurityContext $context, $_24e0e36600d6af77406a44bb618a6253)
    {
        if ($this->IsPeopleAdmin($context)) {
            return $this->extranet_repository->query()->count() > 0;
        }
        if ($_24e0e36600d6af77406a44bb618a6253 == 0) {
            $_161fa4c6089ed7645dda77e187f5b1dd = 0;
            $_35b54f844f87c3db31eca42284fefc39 = 0;
        } else {
            $_24e0e36600d6af77406a44bb618a6253 = $this->GetUser($_24e0e36600d6af77406a44bb618a6253);
            $_161fa4c6089ed7645dda77e187f5b1dd = $_24e0e36600d6af77406a44bb618a6253->id;
            $_35b54f844f87c3db31eca42284fefc39 = $_24e0e36600d6af77406a44bb618a6253->extranet_id;
        }
        if ($_161fa4c6089ed7645dda77e187f5b1dd === 0) {
            return $this->CanCreateUser($context) && $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_31767d7ad58e70" . "6dbf47b7a51a0fe" . "6c4"]($this->GetAssignExtranets($context)) > 1;
        }
        return $this->CanAssignExtranetUsers($context, $_35b54f844f87c3db31eca42284fefc39) && $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_31767d7a" . "d58e706db" . "f47b7a51a" . "0fe6c4"]($this->GetAssignExtranets($context)) > 1;
    }
    public function GetViewableExtranets(SecurityContext $context)
    {
        $_dae07b67d02bf6c77ea37726185346fa = [$context->GetExtranetAreaId(), $this->extranet_repository->getPrimaryExtranet()->id];
        $_dae07b67d02bf6c77ea37726185346fa = $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_f73dab60663" . "0b388645c4f7" . "d3fbb13bb"]($_dae07b67d02bf6c77ea37726185346fa, $this->GetAssignExtranets($context));
        $_dae07b67d02bf6c77ea37726185346fa = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_f73dab606630" . "b388645c4f7d3" . "fbb13bb"]($_dae07b67d02bf6c77ea37726185346fa, $this->GetUpdateExtranets($context));
        $_dae07b67d02bf6c77ea37726185346fa = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_075c6c4172e" . "af58cfa84828" . "a3582d19a"]($_dae07b67d02bf6c77ea37726185346fa);
        return $_dae07b67d02bf6c77ea37726185346fa;
    }
    
    
    
    
    
    
    
    
    
    public function GetUpdateExtranets(SecurityContext $context)
    {
        if ($this->IsPeopleAdmin($context)) {
            return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_ebff9d37a7" . "bb577c57bee" . "4dd9f0e5fd7"]($this->extranet_repository->all()->pluck($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["i" . "d"])->toArray());
        }
        return $this->GetPowerUserAcl($context)->GetOwnersList(self::EDIT, PermOClass::EXTRANET);
    }
    
    
    
    
    
    
    
    
    
    public function GetAssignExtranets(SecurityContext $context)
    {
        if ($this->IsPeopleAdmin($context)) {
            return $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_ebff9d37a7bb577c5" . "7bee4dd9f0e5fd7"]($this->extranet_repository->all()->pluck($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["i" . "d"])->toArray());
        }
        return $this->GetPowerUserAcl($context)->GetOwnersList(self::ASSIGN_TO, PermOClass::EXTRANET);
    }
    
    
    
    
    
    
    
    
    
    
    
    protected function CheckGroupsTree(SecurityContext $context, int $_5630a508eaf62fdbab410362fa17735c, int $group_id)
    {
        $acl = $this->GetPowerUserAcl($context);
        
        
        if ($acl->Has($_5630a508eaf62fdbab410362fa17735c, PermOClass::GROUP, $group_id)) {
            return true;
        }
        
        
        $_eea5f8bfe99a09bd4d06764e8020a0b8 = new GroupFilter($context);
        $_45a2bb6a864189cf6f1ece1b01e3af3c = $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d706c160e45bf7434fff82a" . "5976f0e19"]($this->group_repository->GetAllParentGroups($_eea5f8bfe99a09bd4d06764e8020a0b8, [$group_id]));
        foreach ($_45a2bb6a864189cf6f1ece1b01e3af3c as $_b77d2f7aae585a192c784124a1195dc8) {
            if ($acl->Has($_5630a508eaf62fdbab410362fa17735c, PermOClass::GROUPTREE, $_b77d2f7aae585a192c784124a1195dc8)) {
                return true;
            }
        }
        return false;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function AddObject(SecurityContext $context, int $_fab148434571859ce581a09251188f00, int $object_id)
    {
        
        
        if ($this->IsPeopleAdmin($context)) {
            return;
        }
        $acl = $this->GetPowerUserAcl($context);
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_bd71c3b5c201fc11d" . "b82ed14ce424de5"]($_fab148434571859ce581a09251188f00, [PermOClass::GROUP, PermOClass::ROLE])) {
            if ($_fab148434571859ce581a09251188f00 == PermOClass::GROUP) {
                $_fab148434571859ce581a09251188f00 = PermOClass::GROUPTREE;
            }
            $acl->Add(self::ASSIGN_TO, $_fab148434571859ce581a09251188f00, $object_id);
            $acl->Add(self::EDIT, $_fab148434571859ce581a09251188f00, $object_id);
            $this->acl_repository->Save($acl);
        }
    }
    
    
    
    
    
    
    
    public function GetPowerUserAcl(SecurityContext $context) : Acl
    {
        return $this->acl_repository->Get(PeopleAcl::CLASS_POWER_USER, $context->GetUserId());
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetPowerUserFlags(SecurityContext $context)
    {
        $metadata = $context->GetUser()->GetMetaDataObj();
        $metadata->LoadElement(self::POWER_USER_FLAGS);
        $_b0cf8216499408f540e9d36fba2f4972 = [];
        foreach (self::POWER_USER_FLAGS as $_edae04176aa5d6f554b545456b5c930d) {
            $_b0cf8216499408f540e9d36fba2f4972[$_edae04176aa5d6f554b545456b5c930d] = (bool) (int) $metadata->GetValue($_edae04176aa5d6f554b545456b5c930d);
        }
        return $_b0cf8216499408f540e9d36fba2f4972;
    }
    
    
    
    
    
    
    
    
    
    protected function HasAnyPowerUserFlag(SecurityContext $context) : bool
    {
        $_b0cf8216499408f540e9d36fba2f4972 = $this->GetPowerUserFlags($context);
        foreach ($_b0cf8216499408f540e9d36fba2f4972 as $_edae04176aa5d6f554b545456b5c930d) {
            if ($_edae04176aa5d6f554b545456b5c930d) {
                return true;
            }
        }
        return false;
    }
    
    
    
    
    
    
    
    
    
    
    protected function HasPowerUserFlag(SecurityContext $context, string $_edae04176aa5d6f554b545456b5c930d) : bool
    {
        $_b0cf8216499408f540e9d36fba2f4972 = $this->GetPowerUserFlags($context);
        return $_b0cf8216499408f540e9d36fba2f4972[$_edae04176aa5d6f554b545456b5c930d] ?? false;
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetId($value)
    {
        if ($value instanceof User || $value instanceof Group || $value instanceof Role || $value instanceof Extranet) {
            return $value->id;
        }
        if ($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_5e30c4717ced36cff9e93e19a5" . "c576cc"]($value) && $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_62d701c3c53404f06345e" . "b35720a47b4"]($value)) {
            return (int) $value;
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_680cc2b8220e94c8c32b8bc" . "7c65519b4"]($value)) {
            return $value;
        }
        return 0;
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetUser($value)
    {
        if ($value instanceof User) {
            return $value;
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_5e30c4717ced36cff9e93e19a" . "5c576cc"]($value) && $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_62d701c3c53404f06345eb35720" . "a47b4"]($value)) {
            $value = (int) $value;
        }
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_680cc2b8220e94c8c32b8bc7c65519" . "b4"]($value)) {
            return null;
        }
        
        
        
        
        $_24e0e36600d6af77406a44bb618a6253 = $this->user_repository->find($value);
        return $_24e0e36600d6af77406a44bb618a6253;
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetGroup($value)
    {
        if ($value instanceof Group) {
            return $value;
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_5e30c4717ced36" . "cff9e93e19a5c57" . "6cc"]($value) && $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_62d701c3c53404f063" . "45eb35720a47b4"]($value)) {
            $value = (int) $value;
        }
        if (!$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_680cc2b8220e94c8c32b8bc" . "7c65519b4"]($value)) {
            return null;
        }
        
        
        
        
        $_e9208e4fb555ac989f7519e19c1da810 = $this->group_repository->find($value);
        return $_e9208e4fb555ac989f7519e19c1da810;
    }
    
    
    
    
    
    
    
    
    
    
    protected function GetRole($value)
    {
        if ($value instanceof Role) {
            return $value;
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_5e30c4717ced36cf" . "f9e93e19a5c576cc"]($value) && $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_62d701c3c5" . "3404f06345e" . "b35720a47b4"]($value)) {
            $value = (int) $value;
        }
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_680cc2b8220e94c8c32b8bc7c65519" . "b4"]($value)) {
            return null;
        }
        
        
        
        
        $_d1071a032215f0eb5c4a8ef175f7049d = $this->role_repository->find($value);
        return $_d1071a032215f0eb5c4a8ef175f7049d;
    }
}