<?php
$_db_migration_to = '39.29'; // 8.13.34
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('20230830_statistics_optimisations.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * FRAM-935 Statistics optimisations
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$database = $migrations->GetDb();

// stat_views
$database->CreateIndex('stat_views', 'stat_views_id_aggregation_date_time', 'object_id', 'aggregation', 'date_time');
$database->CreateIndex('stat_views', 'stat_views_id_aggregation_date_time_user_id', 'object_id', 'aggregation', 'date_time', 'user_id');

// stat_visits
$database->CreateIndex('stat_visits', 'idx_session_key_date_time_start', 'session_key', 'date_time_start');
$database->CreateIndex('stat_visits', 'idx_date_time_start', 'date_time_start');


DB_UPDATE_FILE
);


$migrations->Run('20230912_statistics_optimisations.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * FRAM-935 Statistics optimisations
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$database = $migrations->GetDb();

// stat_visits_sum
$database->CreateIndex('stat_visits_sum', 'idx_date_time_user_id', 'date_time', 'user_id');
$database->CreateIndex('stat_visits_sum', 'idx_date_time_pages_visited', 'date_time', 'pages_visited');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('39.29');
