<?php
namespace Claromentis\Core\Localization;

$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] = (@$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"] ?: array()) + array("_7d9ddc77b5329e" . "a478ce5d43e4615" . "f53" => base64_decode("JyBkb2Vzbid0IGV4" . "aXN0"), "_53d43bf1f48959b27c5" . "66cc3f5b06681" => base64_decode("UGhyYXNl" . "ICc="));
use Claromentis\Core\Localization\Exception\MissingPhraseException;








class MemoryProvider implements LocalizationProviderInterface
{
    
    
    
    
    protected $files_reader;
    
    
    
    
    protected $app_code;
    
    
    
    
    protected $lm = array();
    
    
    
    
    protected $lt_parsed = array();
    
    
    
    
    
    
    
    public function __construct($_d901b83ea3a884001dad5ede20f9b05e, Files $_00f2055c7cbd408ef56949f35c62b721)
    {
        $this->app_code = $_d901b83ea3a884001dad5ede20f9b05e;
        $this->files_reader = $_00f2055c7cbd408ef56949f35c62b721;
    }
    
    
    public function getTranslation(string $key, string $language)
    {
        $this->CheckLoadMessages($language);
        if (!isset($this->lm[$language][$key])) {
            throw new MissingPhraseException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_53d43bf1f48959b27c5" . "66cc3f5b06681"] . $key . $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_7d9ddc77b53" . "29ea478ce5d4" . "3e4615f53"]);
        }
        return $this->lm[$language][$key];
    }
    
    
    public function getTemplaterPhrases(string $language) : array
    {
        $this->CheckLoadTemplaterMessages($language);
        return $this->lt_parsed[$language];
    }
    
    
    
    
    
    
    public function CheckLoadMessages($language)
    {
        if (isset($this->lm[$language])) {
            return;
        }
        $this->lm[$language] = [];
        $this->files_reader->ReadLM($this->lm[$language], $this->app_code, $language);
    }
    
    
    
    
    
    
    protected function CheckLoadTemplaterMessages($language)
    {
        if (isset($this->lt_parsed[$language])) {
            return;
        }
        $this->lt_parsed[$language] = array();
        $this->CheckLoadMessages($language);
        $this->files_reader->ReadLT($this->lm[$language], $this->lt_parsed[$language], $this->app_code, $language);
    }
    
    
    public function hasKey(string $key, string $language) : bool
    {
        $this->CheckLoadMessages($language);
        return isset($this->lm[$language][$key]);
    }
    
    
    
    
    public function getDomain() : string
    {
        return (string) $this->app_code;
    }
    
    
    
    
    
    
    
    public function getDataHash(string $language) : ?string
    {
        return $this->files_reader->GetDataHash($this->app_code, $language);
    }
}