<?php
namespace Claromentis\Documents\GoogleDrive;

$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] = (@$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"] ?: array()) + array("_15e3869db2f1ebf4233b10304" . "12f5984" => base64_decode("X2l" . "k"), "_075c6c4172eaf58cfa84828" . "a3582d19a" => base64_decode("YXJy" . "YXlf" . "dW5p" . "cXVl"));
use Google_Client;
use Google_Service_Drive;
use Claromentis\Search\Client\ClientInterface as SearchClient;
use Claromentis\Search\Indexing\Client\ClientInterface as IndexingClient;
use Claromentis\Search\Indexing\IndexingQueue;
use Claromentis\Search\ItemType\Indexing\Document;







class BackgroundController
{
    
    
    
    
    protected $client;
    
    
    
    
    protected $storage;
    
    
    
    
    protected $search;
    
    
    
    
    protected $indexing;
    
    
    
    
    
    
    
    
    
    public function __construct(Google_Client $client, ClientStorage $storage, SearchClient $search, IndexingClient $indexing)
    {
        $this->client = $client;
        $this->storage = $storage;
        $this->search = $search;
        $this->indexing = $indexing;
    }
    
    
    
    
    public function Index()
    {
        $this->ReindexChanges();
    }
    
    
    
    
    
    
    protected function RetrieveChanges()
    {
        $_8bb16d01e9485b11a09ff09f8e18ca59 = new \Google_Service_Drive($this->client);
        
        
        $_1ca5d32ca76f236db3cb4003749ca16c = $this->storage->GetPageToken();
        
        
        if (empty($_1ca5d32ca76f236db3cb4003749ca16c)) {
            $_fd5a3a643834299cbdadfc3540ba0bcb = $_8bb16d01e9485b11a09ff09f8e18ca59->changes->getStartPageToken();
            $_1ca5d32ca76f236db3cb4003749ca16c = $_fd5a3a643834299cbdadfc3540ba0bcb->getStartPageToken();
        }
        $_6be7ef0f685c2a96fcae1fc2ccc30198 = $_8bb16d01e9485b11a09ff09f8e18ca59->changes->listChanges($_1ca5d32ca76f236db3cb4003749ca16c);
        return $_6be7ef0f685c2a96fcae1fc2ccc30198;
    }
    
    
    
    
    
    
    
    
    protected function GetDocumentsToIndex($file_ids)
    {
        $_6c90b08a889ad29eac71c07e475f4824 = array();
        $_f11369824f533e8206f9ccc0c9aab3a0 = 100;
        $_1f50e30be8c2fefa6881834e71d504a2 = 0;
        do {
            $_7f5aa4e96d4b415a86ed72ebff677cbe = new ElasticsearchQuery($file_ids, $_f11369824f533e8206f9ccc0c9aab3a0, $_1f50e30be8c2fefa6881834e71d504a2);
            $_b4af1f7aa1ccde1a449e9d8afe15b753 = $this->search->Search($_7f5aa4e96d4b415a86ed72ebff677cbe);
            foreach ($_b4af1f7aa1ccde1a449e9d8afe15b753->GetResults() as $_1f24efd4735b7a11b391147435e7d35d) {
                $_6c90b08a889ad29eac71c07e475f4824[] = $_1f24efd4735b7a11b391147435e7d35d[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_15e3869db2f1ebf4233b" . "1030412f5984"]];
            }
            $_1f50e30be8c2fefa6881834e71d504a2 += $_f11369824f533e8206f9ccc0c9aab3a0;
        } while ($_1f50e30be8c2fefa6881834e71d504a2 < $_b4af1f7aa1ccde1a449e9d8afe15b753->GetNumResults());
        return $_6c90b08a889ad29eac71c07e475f4824;
    }
    
    
    
    
    
    
    public function ReindexChanges()
    {
        
        
        $_6be7ef0f685c2a96fcae1fc2ccc30198 = $this->RetrieveChanges();
        $file_ids = array();
        
        
        foreach ($_6be7ef0f685c2a96fcae1fc2ccc30198 as $_80838b9941420623658b0a221f9953d1) {
            $file_ids[] = $_80838b9941420623658b0a221f9953d1->fileId;
        }
        
        
        $_008f6ae2e5f89e09baff34c0d2fea915 = $this->GetDocumentsToIndex($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_075c6c4172" . "eaf58cfa848" . "28a3582d19a"]($file_ids));
        
        
        foreach ($_008f6ae2e5f89e09baff34c0d2fea915 as $id) {
            IndexingQueue::Reindex(Document::TYPE_NAME, $id);
        }
        
        
        $_483cee9069ce4f97dbdf12323218908f = $_6be7ef0f685c2a96fcae1fc2ccc30198->getNextPageToken() ?: $_6be7ef0f685c2a96fcae1fc2ccc30198->getNewStartPageToken();
        $this->storage->SetPageToken($_483cee9069ce4f97dbdf12323218908f);
    }
}