<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"] ?: array()) + array("_475b790a6e102713251c443" . "1bc8ddbe4" => base64_decode("bH" . "Ry" . "aW" . "0="), "_c91b0ff19f" . "81a8873a459" . "3a23719472c" => base64_decode("cnRya" . "W0="), "_87daa84e346f6420a3f3426e05d16a7" . "b" => base64_decode("Lw=" . "="), "_8aa39710a39f226efce78e97c7bcd7" . "86" => base64_decode("XC" . "8="), "_e46a1b6a2fd927d616377ae17620" . "d766" => base64_decode("dmlzaWJpbGl0e" . "Q=="));
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;






class SubdirectoryFilesystem implements FilesystemInterface
{
    
    
    
    
    
    
    protected FilesystemInterface $filesystem;
    
    
    
    
    
    
    protected string $prefix;
    
    
    
    
    
    
    
    
    protected ?string $default_visibility;
    
    
    
    
    
    
    
    
    public function __construct(FilesystemInterface $_33eb931581b031fdb2a1937880fb89cd, string $prefix, ?string $_47f2d3f7fb45611e7cd8a735e4b9964d = null)
    {
        $this->filesystem = $_33eb931581b031fdb2a1937880fb89cd;
        $this->prefix = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_c91b0ff19f81a887" . "3a4593a23719472c"]($prefix, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_8aa39710a39f226" . "efce78e97c7bcd78" . "6"]);
        $this->default_visibility = $_47f2d3f7fb45611e7cd8a735e4b9964d;
    }
    
    
    
    
    
    
    
    protected function ApplyPrefix(string $path) : string
    {
        return $this->prefix . $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_87daa84e346f6420a3" . "f3426e05d16a7b"] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_475b790a6e102713251c4431bc8dd" . "be4"]($path, $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_8aa39710a39f226efce78e97c7bcd7" . "86"]);
    }
    
    
    
    
    
    
    
    protected function ApplyVisibility(string $path) : void
    {
        if (isset($this->default_visibility)) {
            $this->filesystem->SetVisibility($this->ApplyPrefix($path), $this->default_visibility);
        }
    }
    public function GetLocalPath(string $path) : string
    {
        return $this->filesystem->GetLocalPath($this->ApplyPrefix($path));
    }
    public function IsDir(string $path) : bool
    {
        return $this->filesystem->IsDir($this->ApplyPrefix($path));
    }
    public function GetMetadata(string $path) : array
    {
        return $this->filesystem->GetMetadata($this->ApplyPrefix($path));
    }
    public function Delete(string $path) : void
    {
        $this->filesystem->Delete($this->ApplyPrefix($path));
    }
    public function Exists(string $path) : bool
    {
        return $this->filesystem->Exists($this->ApplyPrefix($path));
    }
    public function GetUrl(string $path) : ?string
    {
        return $this->filesystem->GetUrl($this->ApplyPrefix($path));
    }
    public function GetStream(string $path)
    {
        return $this->filesystem->GetStream($this->ApplyPrefix($path));
    }
    public function Read(string $path) : string
    {
        return $this->filesystem->Read($this->ApplyPrefix($path));
    }
    public function GetUsedSpace() : string
    {
        return $this->filesystem->GetUsedSpace();
    }
    public function ListContents(string $path) : array
    {
        return $this->filesystem->ListContents($this->ApplyPrefix($path));
    }
    public function ListContentsInfo(string $path) : array
    {
        return $this->filesystem->ListContentsInfo($this->ApplyPrefix($path));
    }
    public function ListContentsRecursive(string $path) : array
    {
        return $this->filesystem->ListContentsRecursive($this->ApplyPrefix($path));
    }
    public function ListDirs(string $path) : array
    {
        return $this->filesystem->ListDirs($this->ApplyPrefix($path));
    }
    public function ListFiles(string $path) : array
    {
        return $this->filesystem->ListFiles($this->ApplyPrefix($path));
    }
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_e46a1b6a2f" . "d927d616377" . "ae17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_e46a1b6a2fd927d616377ae17620" . "d766"]] ?? $this->default_visibility;
        $this->filesystem->PutFromFile($this->ApplyPrefix($path), $_9211dd0bbcae0c7133030df599ff9ef5, $config);
    }
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_e46a1b6a2fd927d61637" . "7ae17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_e46a1b6a2fd927d616377ae17620d76" . "6"]] ?? $this->default_visibility;
        $this->filesystem->PutFromStream($this->ApplyPrefix($path), $_1cc5aa2f679b575f82786a73f0da28f8, $config);
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_e46a1b6a2fd927d616377ae17620d76" . "6"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_e46a1b6a2fd927d61637" . "7ae17620d766"]] ?? $this->default_visibility;
        $this->filesystem->Put($this->ApplyPrefix($path), $_d34599daeb8cca374d3adb38b245839c);
    }
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_e46a1b6a2fd927d616377a" . "e17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_e46a1b6a2fd927d616377ae176" . "20d766"]] ?? $this->default_visibility;
        $this->filesystem->UpdateFromFile($this->ApplyPrefix($path), $_9211dd0bbcae0c7133030df599ff9ef5, $config);
    }
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_e46a1b6a2fd927d616377ae17620d76" . "6"]] = $config[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_e46a1b6a2fd927d616377" . "ae17620d766"]] ?? $this->default_visibility;
        $this->filesystem->UpdateFromStream($this->ApplyPrefix($path), $_1cc5aa2f679b575f82786a73f0da28f8, $config);
    }
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_e46a1b6a2fd927d616377a" . "e17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_e46a1b6" . "a2fd927d" . "616377ae" . "17620d76" . "6"]] ?? $this->default_visibility;
        $this->filesystem->Update($this->ApplyPrefix($path), $_d34599daeb8cca374d3adb38b245839c, $config);
    }
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_e46a1b6a2fd927d616377ae176" . "20d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_e46a1b6a2f" . "d927d616377" . "ae17620d766"]] ?? $this->default_visibility;
        $this->filesystem->WriteFromFile($this->ApplyPrefix($path), $_9211dd0bbcae0c7133030df599ff9ef5, $config);
    }
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_e46a1b6a2fd927d616" . "377ae17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_e46a1b6a2fd92" . "7d616377ae1762" . "0d766"]] ?? $this->default_visibility;
        $this->filesystem->WriteFromStream($this->ApplyPrefix($path), $_1cc5aa2f679b575f82786a73f0da28f8, $config);
    }
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $config[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_e46a1b6a2fd927d6" . "16377ae17620d766"]] = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_e46a1b6a2fd927d616377ae17620" . "d766"]] ?? $this->default_visibility;
        $this->filesystem->Write($this->ApplyPrefix($path), $_d34599daeb8cca374d3adb38b245839c, $config);
    }
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        $this->filesystem->SetVisibility($this->ApplyPrefix($path), $_e46a1b6a2fd927d616377ae17620d766);
    }
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        $this->filesystem->RegisterProtocol($_21f5dd11309da4af2e51660e6f110a91);
    }
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $this->filesystem->Rename($this->ApplyPrefix($path), $this->ApplyPrefix($_d074d7b344040d95fcad55b4694d9fec));
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $this->filesystem->Copy($path, $_d074d7b344040d95fcad55b4694d9fec);
    }
}