<?php
namespace Claromentis\People\Controller\Rest;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] ?: array()) + array("_0ef58d1ad10b6ac762ed9c5" . "940c6feb7" => base64_decode("RXJyb3IgY3JlY" . "XRpbmcgcm9sZQ" . "=="), "_c894747360c6ec5bd81" . "69530eaf9c473" => base64_decode("QmFkIFJlcXVl" . "c3Q="), "_aabddb8e5540f596ece10005c132c" . "6b6" => base64_decode("RXJyb3Igc2V0dGlu" . "ZyByb2xlIHVzZXJz"), "_3efc5ba7bf51ca70907f5e65" . "ab602ec1" => base64_decode("SW50ZXJuYWwg" . "U2VydmVyIEVy" . "cm9y"), "_79bd87060993ff622ef212c1e" . "8b6a79a" => base64_decode("Rm9yYmlk" . "ZGVu"), "_94c782c8180766e1ff1870975a93053" . "d" => base64_decode("Um9sZSBub3QgZm" . "91bmQ="), "_25fb31f00b26bde87effd4759e283d" . "9f" => base64_decode("cm9sZV9p" . "ZHM="), "_3682611" . "b4932733" . "eb97863f" . "a0b39670" . "0" => base64_decode("RXJyb3IgdXBkYXRpbmcgcm9" . "sZQ=="), "role" . "_id" => base64_decode("cm9sZV9p" . "ZA=="), "_67b69c042" . "916369a28c" . "74a7c8b278" . "522" => base64_decode("RXJyb3IgZGVsZXRpb" . "mcgcm9sZQ=="), "_a4a1018258adabb74e7b04836d8d7e3" . "b" => base64_decode("Tm90IE" . "ZvdW5k"));
use Analogue\ORM\Exceptions\MappingException;


use Claromentis\Core\Http\JsonPrettyResponse;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\People\Exception\NotFoundException;
use Claromentis\People\Exception\PermissionException;
use Claromentis\People\Exception\ValidationException;
use Claromentis\People\Filter\RoleFilter;
use Claromentis\People\Filter\UserFilter;
use Claromentis\People\RestFormatter;
use Claromentis\People\UseCase\CreateRole;
use Claromentis\People\UseCase\DeleteRole;
use Claromentis\People\UseCase\GetRole;
use Claromentis\People\UseCase\GetRoles;
use Claromentis\People\UseCase\GetRoleUsers;
use Claromentis\People\UseCase\SetRoleUsers;
use Claromentis\People\UseCase\UpdateRole;
use InvalidArgumentException;
use Psr\Http\Message\ServerRequestInterface as Request;
use RestExBadRequest;
use RestExError;
use RestExForbidden;
use RestExNotFound;
use UnexpectedValueException;






class RoleController extends AbstractController
{
    
    
    
    
    protected $formatter;
    
    
    
    
    protected $get_role;
    
    
    
    
    protected $get_roles;
    
    
    
    
    protected $create_role;
    
    
    
    
    protected $update_role;
    
    
    
    
    protected $delete_role;
    
    
    
    
    protected $get_role_users;
    
    
    
    
    protected $set_role_users;
    
    
    
    
    
    
    
    
    
    
    
    public function __construct(RestFormatter $formatter, GetRole $get_role, GetRoles $get_roles, CreateRole $create_role, UpdateRole $update_role, DeleteRole $delete_role, GetRoleUsers $get_role_users, SetRoleUsers $set_role_users)
    {
        $this->formatter = $formatter;
        $this->get_role = $get_role;
        $this->get_roles = $get_roles;
        $this->create_role = $create_role;
        $this->update_role = $update_role;
        $this->delete_role = $delete_role;
        $this->get_role_users = $get_role_users;
        $this->set_role_users = $set_role_users;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetOne(SecurityContext $context, Request $request, $role_id)
    {
        $use_case = $this->get_role;
        try {
            $_03e9164d0a343b742df4793268b80767 = new RoleFilter($context);
            $_03e9164d0a343b742df4793268b80767->Fill($this->formatter->GetRequestParams($request, $_03e9164d0a343b742df4793268b80767->GetDefaults()));
            $_d1071a032215f0eb5c4a8ef175f7049d = $use_case->GetRole($context, $role_id, $_03e9164d0a343b742df4793268b80767);
            return new JsonPrettyResponse($this->formatter->FormatRole($_d1071a032215f0eb5c4a8ef175f7049d, $_03e9164d0a343b742df4793268b80767));
        } catch (InvalidArgumentException|ValidationException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_c894747360c6ec" . "5bd8169530eaf9c" . "473"], $exception);
        } catch (NotFoundException $exception) {
            throw new RestExNotFound($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_a4a1018258adabb74e7b04836d8d7" . "e3b"], $exception);
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_79bd87060993ff622ef212c1e8b6a" . "79a"], $exception);
        }
    }
    
    
    
    
    
    
    
    
    
    public function GetList(SecurityContext $context, Request $request)
    {
        try {
            $_03e9164d0a343b742df4793268b80767 = new RoleFilter($context);
            $_03e9164d0a343b742df4793268b80767->Fill($this->formatter->GetRequestParams($request, $_03e9164d0a343b742df4793268b80767->GetDefaults()));
            [$_23ab4dd81b6c619f47099ef7c2485a12, $total] = $this->get_roles->GetRoles($_03e9164d0a343b742df4793268b80767);
            $response = $this->formatter->Paginate($request, $this->formatter->FormatRoles($_23ab4dd81b6c619f47099ef7c2485a12, $_03e9164d0a343b742df4793268b80767), $_03e9164d0a343b742df4793268b80767->GetChanged(), $total);
        } catch (InvalidArgumentException|UnexpectedValueException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_c894747360c6ec5bd8169530eaf9" . "c473"], $exception);
        }
        return new JsonPrettyResponse($response);
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Post(SecurityContext $context, Request $request)
    {
        try {
            $_d1071a032215f0eb5c4a8ef175f7049d = $this->create_role->CreateRole($context, $this->formatter->GetJson($request));
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_79bd87060993ff622ef212c1e8b6a" . "79a"], $exception);
        } catch (ValidationException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_c894747360c6ec5bd8" . "169530eaf9c473"], $exception);
        } catch (MappingException $exception) {
            throw new RestExError($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_0ef58d1ad10b" . "6ac762ed9c594" . "0c6feb7"], 500, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_3efc5ba7bf51ca70907f5e65" . "ab602ec1"], $exception);
        } catch (InvalidArgumentException|UnexpectedValueException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_c894747360c6ec5bd816953" . "0eaf9c473"], $exception);
        }
        return new JsonPrettyResponse($this->formatter->FormatRole($_d1071a032215f0eb5c4a8ef175f7049d), 201);
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Put(SecurityContext $context, Request $request)
    {
        try {
            $_d1071a032215f0eb5c4a8ef175f7049d = $this->update_role->UpdateRole($context, $this->formatter->GetRequestParam($request, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["role_i" . "d"]), $this->formatter->GetJson($request));
            return new JsonPrettyResponse($this->formatter->FormatRole($_d1071a032215f0eb5c4a8ef175f7049d));
        } catch (NotFoundException $exception) {
            throw new RestExNotFound($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_a4a1018258adabb74e" . "7b04836d8d7e3b"], $exception);
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_79bd870" . "60993ff6" . "22ef212c" . "1e8b6a79" . "a"], $exception);
        } catch (ValidationException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_c894747360c6ec5bd8" . "169530eaf9c473"], $exception);
        } catch (MappingException $exception) {
            throw new RestExError($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_3682611b4932733eb978" . "63fa0b396700"], 500, $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_3efc5ba7bf51ca70907f5e65ab6" . "02ec1"], $exception);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Delete(SecurityContext $context, Request $request)
    {
        try {
            $this->delete_role->DeleteRole($context, $this->formatter->GetRequestParam($request, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["ro" . "le" . "_i" . "d"]));
        } catch (NotFoundException $exception) {
            throw new RestExNotFound($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_a4a1018258adabb74e7b" . "04836d8d7e3b"], $exception);
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_79bd87060993ff622e" . "f212c1e8b6a79a"], $exception);
        } catch (MappingException $exception) {
            throw new RestExError($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_67b69c042916369a28c74a7c8b2" . "78522"], 500, $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_3efc5ba7bf5" . "1ca70907f5e6" . "5ab602ec1"], $exception);
        }
        return new JsonPrettyResponse(null, 204);
        
        
    }
    
    
    
    
    
    
    
    
    
    
    
    public function GetUsers(SecurityContext $context, Request $request)
    {
        try {
            $_03e9164d0a343b742df4793268b80767 = new UserFilter($context);
            $_03e9164d0a343b742df4793268b80767->Fill($this->formatter->GetRequestParams($request, $_03e9164d0a343b742df4793268b80767->GetDefaults()));
            list($_e4543e131c67c631b14751cc849d1310, $total) = $this->get_role_users->GetRoleUsers($context, $this->formatter->GetRequestParam($request, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["role_i" . "d"]), $_03e9164d0a343b742df4793268b80767);
            $response = $this->formatter->Paginate($request, $this->formatter->FormatUsers($_e4543e131c67c631b14751cc849d1310, $_03e9164d0a343b742df4793268b80767), $_03e9164d0a343b742df4793268b80767->GetChangedWithout([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_25fb31f00b26bde87effd47" . "59e283d9f"]]), $total);
        } catch (NotFoundException $exception) {
            throw new RestExNotFound($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_94c782c8180766" . "e1ff1870975a930" . "53d"], $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_a4a1018" . "258adabb" . "74e7b048" . "36d8d7e3" . "b"], $exception);
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_79bd87060993ff622ef212c1e8" . "b6a79a"], $exception);
        } catch (InvalidArgumentException|UnexpectedValueException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_c894747360c6ec5bd8169530eaf9c4" . "73"], $exception);
        }
        return new JsonPrettyResponse($response);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    public function PutUsers(SecurityContext $context, Request $request)
    {
        try {
            $_e4543e131c67c631b14751cc849d1310 = $this->set_role_users->SetRoleUsers($context, $this->formatter->GetRequestParam($request, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["role_" . "id"]), $this->formatter->PluckRequestIds($request));
            return new JsonPrettyResponse($this->formatter->FormatUsers($_e4543e131c67c631b14751cc849d1310));
        } catch (NotFoundException $exception) {
            throw new RestExNotFound($exception->getMessage(), $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_a4a1018258adabb74" . "e7b04836d8d7e3b"], $exception);
        } catch (PermissionException $exception) {
            throw new RestExForbidden($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_79bd87060993ff622ef2" . "12c1e8b6a79a"], $exception);
        } catch (ValidationException $exception) {
            throw new RestExBadRequest($exception->getMessage(), $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_c894747360c6ec5bd" . "8169530eaf9c473"], $exception);
        } catch (MappingException $exception) {
            throw new RestExError($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_aabddb8e5540" . "f596ece10005c" . "132c6b6"], 500, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_3efc5ba7bf51ca70907f5e65" . "ab602ec1"], $exception);
        }
    }
}