<?php
namespace Claromentis\Core\Acl\Simple;

$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array("_c244a470df52d" . "1d5a7085138ec9" . "4e393" => base64_decode("dW5zZXJpYWxpem" . "U="), "_d706c160e45bf743" . "4fff82a5976f0e19" => base64_decode("YXJyYXlfa2V5cw" . "=="), "_aed8da0f1909121" . "4b78f80351048517" . "c" => base64_decode("c3R" . "ybG" . "Vu"), "_7f628626dd1d55c" . "71b1fc0932ffd1d2" . "c" => base64_decode("aXNfYXJyYX" . "k="), "_2b97c0ca1bb9e7" . "0cb77f4fbf2e523" . "d8d" => base64_decode("Q2FuJ3QgZGVsZXRlIH" . "Blcm1pc3Npb246IHVz" . "ZXIgSUQgaXMgbm90IH" . "NwZWNpZmllZA=="), "_7e4946b30" . "c25f9bccba" . "6f75095033" . "0de" => base64_decode("Q2FuJ3QgZ2V0IHBlcm1pc3Npb25zOiB1c2VyIElEIGl" . "zIG5vdCBzcGVjaWZpZWQ="), "_96be32a6f44bf54e635e1" . "736acf7a96c" => base64_decode("c2VyaWFsaXp" . "l"), "_70809333a0f254acf7a1ad0c7da" . "dd46b" => base64_decode("OiA" . "="));
use Claromentis\Core\Acl\Exception\InvalidSubjectException;
use Claromentis\Core\Acl\PermOClass;






class SimpleAcl
{
    const STANDARD = 1;
    protected $object_code;
    protected $rights;
    
    
    
    
    
    
    public function __construct(string $_65c616d6ef3c21352d2d44595fdf776b = '')
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
        $this->Clear();
    }
    public function SetObjectCode(string $_65c616d6ef3c21352d2d44595fdf776b)
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
    }
    public function GetObjectCode() : string
    {
        return $this->object_code;
    }
    
    
    
    
    public function Clear()
    {
        $this->Hydrate(array());
    }
    
    
    
    
    
    
    public function Hydrate(array $rights)
    {
        $this->rights = $rights;
    }
    
    
    
    
    
    
    
    
    
    public function Grant(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            return true;
        }
        if (!isset($this->rights[$user_id])) {
            $this->rights[$user_id] = $perms;
        } else {
            $this->rights[$user_id] |= $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    public function Permits(int $user_id, int $perms = 0)
    {
        if ($perms === 0) {
            return !empty($this->rights[$user_id]);
        }
        $p = $this->Get($user_id);
        return $p & $perms == $perms;
    }
    
    
    
    
    
    
    
    
    
    public function Set(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            unset($this->rights[$user_id]);
        } else {
            $this->rights[$user_id] = $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function SetMany(array $_5882c836e9757b405d08e77f1fd2a18b, int $perms = self::STANDARD)
    {
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $this->Set($user_id, $perms);
        }
    }
    
    
    
    
    
    
    
    
    public function Get(int $user_id) : int
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_7e4946b30c25f9bccba" . "6f750950330de"]);
        }
        if (!isset($this->rights[$user_id])) {
            return 0;
        }
        return $this->rights[$user_id];
    }
    
    
    
    
    
    
    
    public function Delete(int $user_id, int $perms = 0)
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_2b97c0ca1bb9e7" . "0cb77f4fbf2e523" . "d8d"]);
        }
        if ($perms === 0) {
            unset($this->rights[$user_id]);
        }
        $this->Set($this->Get($user_id) & ~$perms, $user_id);
    }
    
    
    
    
    
    
    
    
    public function CreateCopy(string $_65c616d6ef3c21352d2d44595fdf776b) : SimpleAcl
    {
        $acl = new SimpleAcl($_65c616d6ef3c21352d2d44595fdf776b);
        $acl->Hydrate($this->GetRights());
        return $acl;
    }
    
    
    
    
    
    
    
    
    public function GetRights(int $perms = 0) : array
    {
        if ($perms === 0) {
            return $this->rights;
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[$user_id] = $p;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    
    public function GetIndividualsList(int $perms = 0)
    {
        if ($perms === 0) {
            return $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_d706c160e45bf" . "7434fff82a5976" . "f0e19"]($this->rights);
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[] = $user_id;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    public function AsTextStrings() : array
    {
        $_a91f531562c56061228ba02b34c36a79 = [];
        $_5882c836e9757b405d08e77f1fd2a18b = $this->GetIndividualsList();
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $_a91f531562c56061228ba02b34c36a79[] = PermOClass::GetName(PermOClass::INDIVIDUAL) . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_70809333a0f254acf7a1a" . "d0c7dadd46b"] . \User::GetNameById($user_id);
        }
        return $_a91f531562c56061228ba02b34c36a79;
    }
    
    
    
    
    public function Serialize() : string
    {
        return $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_96be32a6f44bf54e635e1736acf7" . "a96c"]($this->rights);
    }
    
    
    
    
    public function Unserialize(string $_34460bffd3af92da81e46ee15e9e66e3)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_aed8da0f19091214b78f80351" . "048517c"]($_34460bffd3af92da81e46ee15e9e66e3) > 0) {
            $rights = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_c244a470df52d1d5a7085" . "138ec94e393"]($_34460bffd3af92da81e46ee15e9e66e3);
            if ($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_7f628626dd1d55c71b1" . "fc0932ffd1d2c"]($rights)) {
                $this->Hydrate($rights);
            }
        }
    }
}