<?php
namespace Claromentis\People\Validator;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] ?: array()) + array("_bd71c3b5c201fc11db82ed14ce424" . "de5" => base64_decode("aW5fYXJyY" . "Xk="), "_56e057e6e60ee281" . "5b7034e74787474d" => base64_decode("VGhlIFByaW1hcnkgRXh0cmFuZXQgY2Fubm90IG" . "JlIGRlbGV0ZWQ="), "_742c76e4c" . "ec99feecec" . "4223ee30c1" . "cff" => base64_decode("YXJyYXlfaW50ZX" . "JzZWN0"), "_c06c961f393742ecfd52b72263ac947" . "0" => base64_decode("aW50d" . "mFs"), "_921fbf4c866dff55f6a4cab0c7b" . "e03ff" => base64_decode("bmV3X2V4dHJhbm" . "V0X2lk"), "_166b84790b560d7028821b9f8114" . "0da7" => base64_decode("cmVh" . "ZF9v" . "bmx5"), "_b66252d7bbf3610" . "12a6531a8e3a7323" . "0" => base64_decode("YXJyYXlf" . "ZGlmZg=="), "_5e30c4717ced" . "36cff9e93e19a" . "5c576cc" => base64_decode("aXNfc3" . "RyaW5n"), "_4d707fab93bebb00bbe69e8159697c9" . "0" => base64_decode(""), "_28a01c8e8c6cb665cc83d" . "03df4a6977b" => base64_decode("YWRta" . "W5faW" . "Q="), "_d706c160e45bf743" . "4fff82a5976f0e19" => base64_decode("YXJyY" . "Xlfa2" . "V5cw=" . "="), "_3485471e3a3" . "6e65fb5fc93a" . "4bd99c347" => base64_decode("cHJpbWFy" . "eQ=="), "_f73dab6" . "06630b38" . "8645c4f7" . "d3fbb13b" . "b" => base64_decode("YXJyYXlf" . "bWVyZ2U="), "na" . "me" => base64_decode("bmF" . "tZQ" . "=="));
use Claromentis\Core\Localization\Lmsg;
use Claromentis\People\Entity\Extranet;
use Claromentis\People\Exception\NotFoundException;
use Claromentis\People\Exception\ValidationException;
use Claromentis\People\Repository\ExtranetRepository;
use Claromentis\People\Repository\UserRepository;
class ExtranetValidator
{
    const E_MISSING_PROP = 'people.error.extranet_prop_missing';
    const E_INVALID_PROP = 'people.error.extranet_prop_invalid';
    const E_FORBIDDEN_PROP = 'people.error.extranet_prop_forbidden';
    const E_NO_USER = 'people.error.no_user_with_id';
    const E_NAME_NOT_STRING = 'people.error.name_not_string';
    const E_PROP_NOT_INT = 'people.error.prop_not_int';
    const E_PROP_NOT_BOOL = 'people.error.prop_not_bool';
    const E_MOVETO_NOT_EXIST = 'people.error.move_to_not_exist';
    const E_NO_MOVE_TO_SELF = 'people.error.cannot_move_to_self';
    const E_USER_LIST_EMPTY = 'people.error.cannot_move_to_self';
    const E_ID_NOT_INT = 'people.error.ex_id_not_int';
    const E_EX_NOT_FOUND = 'people.error.ex_id_not_found';
    const E_INVALID = 'people.error.extranet_invalid';
    const REQUIRED_PROPS = ['name'];
    const OPTIONAL_PROPS = ['description' => '', 'primary' => false, 'admin_id' => 1, 'read_only' => false];
    const FORBIDDEN_PROPS = ['logo_file' => '', 'default_skin' => 0];
    
    
    
    
    protected $lmsg;
    
    
    
    
    private $repo;
    
    
    
    
    private $user_repo;
    
    
    
    
    
    
    private $errors;
    public function __construct(ExtranetRepository $_8652ba33e6ffeba02459fa9cbb320851, UserRepository $_eeeeb0d673b7b0fd0bdca58b5541c3e0, Lmsg $lmsg)
    {
        $this->repo = $_8652ba33e6ffeba02459fa9cbb320851;
        $this->user_repo = $_eeeeb0d673b7b0fd0bdca58b5541c3e0;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Validate($extranet_id, array $_809a58dc73011173c031a53c0b40ef0e) : array
    {
        $this->errors = [];
        if ($extranet_id) {
            $this->JustValidateId($extranet_id);
        } else {
            $this->ValidateRequired($_809a58dc73011173c031a53c0b40ef0e);
        }
        $this->ValidateGiven($_809a58dc73011173c031a53c0b40ef0e);
        $this->CheckErrors();
        $_809a58dc73011173c031a53c0b40ef0e = $this->FillDefaults($_809a58dc73011173c031a53c0b40ef0e);
        return $_809a58dc73011173c031a53c0b40ef0e;
    }
    protected function ValidateRequired(array $_809a58dc73011173c031a53c0b40ef0e)
    {
        $_565d7be99acb0b7627e48da068eebbd6 = self::REQUIRED_PROPS;
        $_57bfe1aba9b3b4c0d83917252d966e54 = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_b66252d7bbf361012a653" . "1a8e3a73230"]($_565d7be99acb0b7627e48da068eebbd6, $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_d706c160e45bf7434fff8" . "2a5976f0e19"]($_809a58dc73011173c031a53c0b40ef0e));
        foreach ($_57bfe1aba9b3b4c0d83917252d966e54 as $_1db43cd03f8bd98e220af46d31486c0a) {
            $this->errors[] = ($this->lmsg)(self::E_MISSING_PROP, $_1db43cd03f8bd98e220af46d31486c0a);
        }
    }
    protected function ValidateGiven(array $_809a58dc73011173c031a53c0b40ef0e)
    {
        $_1ac0335a1f605e216d9ffde5545a81e3 = $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_f73dab606630" . "b388645c4f7d3" . "fbb13bb"](self::REQUIRED_PROPS, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d706c160e45bf7434fff82a597" . "6f0e19"](self::OPTIONAL_PROPS));
        $_aec8d9f47694b74c797ec564d725be1b = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_742c76e4cec99feecec4223ee30" . "c1cff"]($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_d706c160e45bf" . "7434fff82a5976" . "f0e19"]($_809a58dc73011173c031a53c0b40ef0e), $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_d706c160e45bf7434fff8" . "2a5976f0e19"](self::FORBIDDEN_PROPS));
        $_8ff8e4bd4ac206f84359062c2ca26a03 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_b66252d7bbf361012" . "a6531a8e3a73230"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_d706c160e45bf7434ff" . "f82a5976f0e19"]($_809a58dc73011173c031a53c0b40ef0e), $_1ac0335a1f605e216d9ffde5545a81e3);
        foreach ($_aec8d9f47694b74c797ec564d725be1b as $_61236c74c787fc6549ed2a436363da5a) {
            $this->errors[] = ($this->lmsg)(self::E_FORBIDDEN_PROP, $_61236c74c787fc6549ed2a436363da5a);
        }
        foreach ($_8ff8e4bd4ac206f84359062c2ca26a03 as $_53f447bfb52e103171ac7a1e2459fb83) {
            $this->errors[] = ($this->lmsg)(self::E_INVALID_PROP, $_53f447bfb52e103171ac7a1e2459fb83);
        }
        
        
        
        
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["nam" . "e"]]) && (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_5e30c4717" . "ced36cff9e" . "93e19a5c57" . "6cc"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["n" . "a" . "m" . "e"]]) || $_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["nam" . "e"]] == $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_4d707fa" . "b93bebb0" . "0bbe69e8" . "159697c9" . "0"])) {
            $this->errors[] = ($this->lmsg)(self::E_NAME_NOT_STRING);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_28a01c8" . "e8c6cb66" . "5cc83d03" . "df4a6977" . "b"]]) && !$_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_28a01c8e8c6cb665" . "cc83d03df4a6977b"]] == $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_c06c961f393742ecfd52b72263ac94" . "70"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_28a01c8e8c6cb665cc83d03df4a6" . "977b"]])) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_INT, $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_28a01c8e8" . "c6cb665cc8" . "3d03df4a69" . "77b"]);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_3485471e3" . "a36e65fb5f" . "c93a4bd99c" . "347"]]) && !$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_bd71c3b5" . "c201fc11d" . "b82ed14ce" . "424de5"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_3485471e3a36e65fb5fc93a" . "4bd99c347"]], [true, 1, false, 0], true)) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_BOOL, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_3485471e3a36e65fb5fc93" . "a4bd99c347"]);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_166b8479" . "0b560d702" . "8821b9f81" . "140da7"]]) && !$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_bd71c3b5c201fc1" . "1db82ed14ce424de" . "5"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_166b84790b560d7028821b9f81140d" . "a7"]], [true, false, 1, 0], true)) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_BOOL, $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_166b84790b560d7028821b9f81140" . "da7"]);
        }
    }
    protected function FillDefaults(array $_809a58dc73011173c031a53c0b40ef0e) : array
    {
        $_c9a6a047112f57e62ae32e746b3293c7 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f73dab606" . "630b388645" . "c4f7d3fbb1" . "3bb"](self::OPTIONAL_PROPS, self::FORBIDDEN_PROPS);
        
        
        foreach ($_c9a6a047112f57e62ae32e746b3293c7 as $_c241f11ec2591cc626823468234ffaf4 => $default) {
            if (!isset($_809a58dc73011173c031a53c0b40ef0e[$_c241f11ec2591cc626823468234ffaf4])) {
                $_809a58dc73011173c031a53c0b40ef0e[$_c241f11ec2591cc626823468234ffaf4] = $default;
            }
        }
        return $_809a58dc73011173c031a53c0b40ef0e;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function ValidateDelete($extranet_id, $_921fbf4c866dff55f6a4cab0c7be03ff)
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id);
        $_9a2ef4ae6a5745ffe5fac33c88a222fa = $this->repo->find($extranet_id);
        if ($_9a2ef4ae6a5745ffe5fac33c88a222fa->isPrimary()) {
            $this->errors[] = $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_56e057e6e60ee281" . "5b7034e74787474d"];
        }
        if (isset($_921fbf4c866dff55f6a4cab0c7be03ff)) {
            if (!$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_c06c961f393742ecfd5" . "2b72263ac9470"]($_921fbf4c866dff55f6a4cab0c7be03ff)) {
                $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_INT, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_921fbf4c866" . "dff55f6a4cab" . "0c7be03ff"]);
            } elseif ((int) $_921fbf4c866dff55f6a4cab0c7be03ff === (int) $extranet_id) {
                $this->errors[] = ($this->lmsg)(self::E_NO_MOVE_TO_SELF);
            } else {
                try {
                    $this->JustValidateId($_921fbf4c866dff55f6a4cab0c7be03ff, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_921fbf4c8" . "66dff55f6a" . "4cab0c7be0" . "3ff"]);
                } catch (NotFoundException $e) {
                    $this->errors[] = ($this->lmsg)(self::E_MOVETO_NOT_EXIST, $_921fbf4c866dff55f6a4cab0c7be03ff);
                }
            }
        }
        $this->CheckErrors();
    }
    
    
    
    
    
    
    
    
    
    public function ValidateUserList(int $extranet_id, array $user_ids)
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id);
        if (empty($user_ids)) {
            $this->errors[] = ($this->lmsg)(self::E_USER_LIST_EMPTY);
        }
        $_dd93aa31e86867f12566cbfdd849844b = $this->user_repo->checkIds($user_ids);
        $_962607d828e087086dfede27d603d110 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_b66252d7bbf36" . "1012a6531a8e3a" . "73230"]($user_ids, $_dd93aa31e86867f12566cbfdd849844b);
        foreach ($_962607d828e087086dfede27d603d110 as $_3a5a220e178795c7744dcb9ba61a1bd2) {
            $this->errors[] = ($this->lmsg)(self::E_NO_USER, $_3a5a220e178795c7744dcb9ba61a1bd2);
        }
        $this->CheckErrors();
    }
    
    
    
    
    
    
    
    
    
    
    
    public function ValidateId($extranet_id, string $_d4e80b2d16a3e2ee29002ce34922fd11 = 'extranet id')
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id, $_d4e80b2d16a3e2ee29002ce34922fd11);
        $this->CheckErrors();
    }
    
    
    
    
    
    
    protected function JustValidateId($extranet_id, string $_d4e80b2d16a3e2ee29002ce34922fd11 = 'extranet id')
    {
        if (!$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_c06c961f393742" . "ecfd52b72263ac9" . "470"]($extranet_id)) {
            $this->errors[] = ($this->lmsg)(self::E_ID_NOT_INT, $_d4e80b2d16a3e2ee29002ce34922fd11);
        } elseif (!$this->repo->entityExists((int) $extranet_id)) {
            throw new NotFoundException(($this->lmsg)(self::E_EX_NOT_FOUND, $_d4e80b2d16a3e2ee29002ce34922fd11));
        }
    }
    
    
    
    
    protected function CheckErrors()
    {
        if (!empty($this->errors)) {
            $e = new ValidationException(($this->lmsg)(self::E_INVALID));
            $e->validation_errors = $this->errors;
            throw $e;
        }
    }
}