<?php
$_db_migration_to = '23.07'; // 7.2 RC2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_form_styles.php', <<<'DB_UPDATE_FILE'
<?php


$table_descr = array(
    'id'            => "IDENTITY",
    'name'          => "VARCHAR(244)",
    'style'         => "CLOB",
    'is_default'    => "BOOL NOT_NULL DEFAULT 0"
);

$db->RenameTable('fb_form_css', 'fb_form_css_old_temp');
$db->CreateTable('fb_form_css', $table_descr, false);

$results = $db->query("SELECT * FROM fb_form_css_old_temp");

if ($db->type() == 'mssql')
    $db->query("SET IDENTITY_INSERT fb_form_css ON");
while ($result = $results->fetchArray())
{
    $fields = array(
        'int:id'            => $result['id'],
        'str:name'          => $result['name'],
        'clob:style'        => $result['style'],
        'int:is_default'   => $result['is_default']
    );

    $query_insert = new QueryInsert('fb_form_css', $fields);
    $db->query($query_insert);
}
if ($db->type() == 'mssql')
    $db->query("SET IDENTITY_INSERT fb_form_css OFF");

$db->DropTable('fb_form_css_old_temp');
?>

DB_UPDATE_FILE
);


$migrations->Run('02_form_def_styles.php', <<<'DB_UPDATE_FILE'
<?php
$db->DropTable('fb_form_default_css');
?>

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('23.07');
