define(['jquery'], function (jQuery) {
	function DocumentPicker(element_id, button_element_id, hidden_element_id) {
		this.element_id = element_id;
		this.button_element_id = button_element_id;

		// Allow the hidden element ID to change to allow multiple controls on a page
		if (hidden_element_id === undefined)
			hidden_element_id = 'document_id';

		this.hidden_element_id = hidden_element_id;
		// this.extra_query = extra_query;
		// this.$el.data('folder-picker', this);
	}

	DocumentPicker.prototype.init = function () {
		this.$el = jQuery('#' + this.button_element_id);
		// this.$container = this.$el.closest('.js-folder-picker-wrapper');
		var self = this;
		this.$el.on('click', function () {
			self.document_select_show(self.element_id, true);
		});

	};
	// put document ID into element with id = {selector_name}_id, document name into element with id = {selector_name}
	DocumentPicker.prototype.document_selected_callback = function(object_id, object_aggregation, object_name, selector_name)
	{
		var input_el = document.getElementById(selector_name);
		var input_id_el = document.getElementById(this.hidden_element_id);

		if ((input_el == null) || (input_id_el == null)) return false;
		input_id_el.value = object_id;
		input_el.value = object_name;
		input_id_el.dispatchEvent(new Event('change'));
		return true;
	};

	// create single option in <select> element with id = {selector_name}, document ID is value, document title is option text
	DocumentPicker.prototype.document_selected_callback_option = function(object_id, object_aggregation, object_name, selector_name)
	{
		var select_el = document.getElementById(selector_name);
		if (select_el == null) return false;

		select_el.options[0] = new Option(object_name, object_id, true, true);
		return true;
	};


	DocumentPicker.prototype.document_select_show = function(selector_id, show_marker_selectors, callback)
	{
		if (callback == null)
			callback = 'document_selected_callback';
		var selector = document.getElementById(selector_id);
		if (!selector) return false;

//	for(i = 0; i < selector.options.length; ++i)
//		selector.options[i] = null;

		var marker_selector_parameter;
		if (show_marker_selectors == true)
			marker_selector_parameter = 1;
		else
			marker_selector_parameter = 0;

		window.open('/intranet/common/folderstree_popup.php?selector_name='+selector_id
			+'&document_select=1&marker_select=' + marker_selector_parameter + '&folder_select=0&class_select=0&callback=' + callback, 'doc_select_win',
			'dependent=yes,width=500,height=430,screenX=200,screenY=300,titlebar=yes, scrollbars=yes,status=yes,resizable=yes');
		window.document_picker_obj = this;
		return false;
	};


	return DocumentPicker;
});
