<?php
namespace Claromentis\Core\Ai\Adapters\Vertex;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"] ?: array()) + array("_bef1236f88db6b34bcb878fe48142cb" . "6" => base64_decode("aHR0cF9lcnJvc" . "nM="), "_86e718deaf" . "c5b7c86aa63" . "799a9e024d0" => base64_decode("aHR0cHM6" . "Ly8="), "_e2cad529b5b2b661032342010c4" . "96554" => base64_decode("L2xvY2F0aW" . "9ucy8="), "_6ee75f9f44b14f240fc54f3e1" . "9e7084a" => base64_decode("UmVjZWl2ZWQgYW4gdW5leHBlY3RlZCBlcnJvciBmcm9" . "tIHRoZSBzZXJ2ZXI="), "_db618ca8e79f97" . "b4dff753ec83794" . "2cf" => base64_decode("cHJvamVjdF9pZ" . "A=="), "_7681c2a2b7e" . "1bdf69c23c6c" . "d64114ad3" => base64_decode("anNvbl9kZ" . "WNvZGU="), "_8ec8f26c742278f90615f5" . "0d682eea79" => base64_decode("UE9TVA=" . "="), "_3e258c4e6163007d8094c396476" . "02e7a" => base64_decode("aGVhZ" . "GVycw" . "=="), "_043583f" . "c6e4063b" . "e6ec4a31" . "bf951616" . "c" => base64_decode("L3Byb2plY" . "3RzLw=="), "_38021ae38952751ba" . "ca9f63ac2bf723b" => base64_decode("LWFpcGxhdGZvcm0uZ2" . "9vZ2xlYXBpcy5jb20v" . "djE="), "_e9181de682eeb" . "f636bae0512695" . "b2a95" => base64_decode("QXV0aG9yaXphdGlvbg=" . "="), "_47ee521cf79c60b97cda9ecd9c595c" . "95" => base64_decode("U2VydmVyIHJldHVybmVkIGFuIHVuZXhwZWN0ZWQgcmVzcG9uc2UuIEhUVFA" . "gY29kZTog"), "_29225c3f2cb4b5bb8cdf" . "ecad11c6f491" => base64_decode("Og=" . "="), "_7215c118" . "ad8698360" . "2db0b431c" . "b9a1e9" => base64_decode("Z2VuZXJhdGVDb" . "250ZW50"), "_7c819f403b31525f384e33c0142be9" . "f4" => base64_decode("L3B1Ymxpc2hlcnMvZ29v" . "Z2xlL21vZGVscy8="), "_b673c954" . "9489ba191" . "6c266f60d" . "c846a8" => base64_decode("cHJl" . "ZGlj" . "dA=="), "_0cb031e3" . "cd6ff0075" . "d3bccfcfd" . "b999a6" => base64_decode("LCBjb250ZW50" . "OiA="), "_f24852a7b2e8c180d1f7ab" . "216c8e8222" => base64_decode("QmVhcmV" . "yIA=="), "_67a3498b1e8" . "fe53ddf39e40" . "0a59bc91f" => base64_decode("cmVnaW9" . "uX25hbW" . "U="), "_1cc5aa2f679b575f8278" . "6a73f0da28f8" => base64_decode("c3RyZWF" . "t"), "_63a6ec2f20440285232bed95" . "5be33266" => base64_decode("c3RyZWFtR2Vu" . "ZXJhdGVDb250" . "ZW50"));
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Image\VertexAiImageRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Text\VertexAiTextRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\VertexAiClientAuthentication;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Image\VertexAiGenerateImageResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Text\VertexAiGenerateTextResponse;
use Claromentis\Core\Ai\Exceptions\AiException;
use Claromentis\Core\Ai\Exceptions\AiInvalidRequestException;
use Claromentis\Core\Ai\Exceptions\AiServerResponseException;
use Claromentis\Core\Ai\Exceptions\VertexAiPromptException;
use Claromentis\Core\Ai\JsonParser;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Stream\StreamInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\Response;






class VertexAiClient implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    
    
    
    
    
    public const ERROR_INVALID_ARGUMENT = Response::HTTP_BAD_REQUEST;
    public const ERROR_UNAUTHENTICATED = Response::HTTP_UNAUTHORIZED;
    public const ERROR_PERMISSION_DENIED = Response::HTTP_FORBIDDEN;
    public const ERROR_NOT_FOUND = Response::HTTP_NOT_FOUND;
    public const ERROR_RESOURCE_EXHAUSTED = Response::HTTP_TOO_MANY_REQUESTS;
    public const ERROR_CANCELLED = 499;
    
    
    public const ERROR_INTERNAL_ERROR = Response::HTTP_INTERNAL_SERVER_ERROR;
    public const ERROR_UNAVAILABLE = Response::HTTP_SERVICE_UNAVAILABLE;
    public const ERROR_DEADLINE_EXCEEDED = Response::HTTP_GATEWAY_TIMEOUT;
    
    
    
    
    private string $projectId;
    
    
    
    
    private string $regionName;
    
    
    
    
    private string $modelName;
    
    
    
    
    private VertexAiClientAuthentication $authentication;
    
    
    
    
    private ClientInterface $client;
    
    
    
    
    
    
    
    
    
    public function __construct(VertexAiClientAuthentication $_961ccc1b377e30c70011809b405b9c07, array $config, LoggerInterface $logger = null, ClientInterface $_2f664bcc4a0a32ffda2885fb12940265 = null)
    {
        $this->projectId = $config[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_db618ca8e79f97b4dff753ec" . "837942cf"]];
        $this->regionName = $config[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_67a3498b" . "1e8fe53dd" . "f39e400a5" . "9bc91f"]];
        $this->authentication = $_961ccc1b377e30c70011809b405b9c07;
        $this->logger = $logger ?? new NullLogger();
        $this->client = $_2f664bcc4a0a32ffda2885fb12940265 ?? new Client();
    }
    
    
    
    
    
    
    
    
    
    
    public function handleGenerateTextRequest(VertexAiTextRequest $request, callable $_5c51b0e4b7267b43adabf8015a8e1cf8 = null)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        if ($request->isStreaming()) {
            $this->generateTextStream($_f4bd77b9d7574792bd46db73586ce19d, $_5c51b0e4b7267b43adabf8015a8e1cf8);
            return;
        }
        return $this->generateText($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleGenerateImageRequest(VertexAiImageRequest $request)
    {
        
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateImages($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    private function generateText(array $data) : VertexAiGenerateTextResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_7215c118ad86983602db0b431cb9a1e" . "9"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextResponse::fromArray($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_7681c2a2b7e1bdf69c23c6cd6" . "4114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateImages(array $data) : VertexAiGenerateImageResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_b673c9549489ba1916c" . "266f60dc846a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateImageResponse::fromArray($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_7681c2a2b7e" . "1bdf69c23c6c" . "d64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true));
    }
    
    
    
    
    
    
    
    public function buildURL(string $_3bf6f785d3520dfd17a871d18d745880) : string
    {
        return $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_86e718deafc5b7c8" . "6aa63799a9e024d0"] . $this->regionName . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_38021ae38952751baca9f6" . "3ac2bf723b"] . $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_043583fc6e4063be6ec4a31bf" . "951616c"] . $this->projectId . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_e2cad529b5b2b661032342010c" . "496554"] . $this->regionName . $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_7c819f403b31525" . "f384e33c0142be9f" . "4"] . $this->modelName . ($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_29225c3f2cb4b5bb8cdfecad" . "11c6f491"] . $_3bf6f785d3520dfd17a871d18d745880);
    }
    
    
    
    
    
    
    
    
    
    
    
    private function send(string $_c927258f5322288a992c77be40ae0b53, array $data, bool $_1cc5aa2f679b575f82786a73f0da28f8 = false)
    {
        $_fd5a3a643834299cbdadfc3540ba0bcb = $this->client->request($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_8ec8f26c74227" . "8f90615f50d682" . "eea79"], $_c927258f5322288a992c77be40ae0b53, [RequestOptions::JSON => $data, $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_1cc5aa2f679b575f82786a73f0da28" . "f8"] => $_1cc5aa2f679b575f82786a73f0da28f8, $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_bef1236f88db6b34bcb87" . "8fe48142cb6"] => false, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_3e258c4e6163007d8094c396476" . "02e7a"] => [$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_e9181de682eebf636b" . "ae0512695b2a95"] => $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_f24852a7b2e8c" . "180d1f7ab216c8" . "e8222"] . $this->authentication->getAccessToken()]]);
        $this->checkResponse($_fd5a3a643834299cbdadfc3540ba0bcb);
        return $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
    }
    
    
    
    
    
    
    
    
    private function generateTextStream(array $data, callable $_5c51b0e4b7267b43adabf8015a8e1cf8) : void
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_63a6ec2f" . "204402852" . "32bed955b" . "e33266"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        $_1cc5aa2f679b575f82786a73f0da28f8 = $this->send($_c927258f5322288a992c77be40ae0b53, $data, true);
        $_c37f5d387ecde7a206c24852e173b2fe = new JsonParser(function (array $_fd62bc4eaaf7d58dea9bada3e30443b9) use($_5c51b0e4b7267b43adabf8015a8e1cf8) {
            $_5c51b0e4b7267b43adabf8015a8e1cf8(VertexAiGenerateTextResponse::fromArray($_fd62bc4eaaf7d58dea9bada3e30443b9, $this->modelName));
        });
        while (!$_1cc5aa2f679b575f82786a73f0da28f8->eof()) {
            $_c37f5d387ecde7a206c24852e173b2fe->consume($_1cc5aa2f679b575f82786a73f0da28f8->Read(1024));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function checkResponse(\Psr\Http\Message\ResponseInterface $_fd5a3a643834299cbdadfc3540ba0bcb)
    {
        switch ($_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode()) {
            
            
            
            case self::ERROR_UNAUTHENTICATED:
            case self::ERROR_PERMISSION_DENIED:
                throw AiException::invalidCredentials();
            case self::ERROR_INVALID_ARGUMENT:
                throw new AiInvalidRequestException();
            case self::ERROR_NOT_FOUND:
            case self::ERROR_RESOURCE_EXHAUSTED:
            case self::ERROR_CANCELLED:
            case self::ERROR_DEADLINE_EXCEEDED:
            case self::ERROR_INTERNAL_ERROR:
            case self::ERROR_UNAVAILABLE:
                $this->logger->error($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_47ee521cf7" . "9c60b97cda9" . "ecd9c595c95"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode() . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_0cb031e3cd6ff0075d3bccfcfdb999a" . "6"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getBody());
                throw new AiServerResponseException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_6ee75f9f44b" . "14f240fc54f3" . "e19e7084a"], $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode());
        }
    }
}