
var DashboardActionsView = Backbone.View.extend({
	el: '.js-aside-dashboard',
	collection: null,
	all_actions: [],

/*	events: {
		'click .action_element' : "onActionClick"
	},
*/

	initialize: function ()
	{
		this.all_actions = [];
		this.all_actions.push(new DashboardActionView());
		this.all_actions.push(new DashboardActionViewProperties());
		this.all_actions.push(new DashboardActionDownload());
		this.all_actions.push(new DashboardActionDownloadZip());
		this.all_actions.push(new DashboardActionCheckout());
		this.all_actions.push(new DashboardActionCheckin());
		this.all_actions.push(new DashboardActionRenew());
		this.all_actions.push(new DashboardActionDelete());
		this.all_actions.push(new DashboardActionAddBookmark());
		this.all_actions.push(new DashboardActionRemoveBookmark());
		this.all_actions.push(new DashboardActionPermissions());
		this.all_actions.push(new DashboardActionAddToClipboard());
	},

	setCollection: function (collection)
	{
		this.collection = collection;
	},

	render: function ()
	{
		var title;
		if (!this.collection || this.collection.length == 0)
		{
			//title = 'No items selected';  // todo: replace with lmsg() call
			this.$el.hide();
			return;
		}

		this.$el.show();
		title = lmsg('documents.dashboard.items_selected', this.collection.length);
		this.$('.aside_dashboard_header').text(title);

		this.renderActions();
	},

	renderActions: function ()
	{
		var text;
		var el = this.$('.js-aside-dashboard-actions');
		el.empty();
		el.hide();

		for (var i=0; i < this.all_actions.length; i++)
		{
			var action = this.all_actions[i];
			if (this.collection && action.isAllowed(this.collection))
			{
				text = action.render(this.collection);
				text = $(text).data('index', i);
				//text = '<span class="action_element" rel="' + i + '">' + text + "</span>\n";
				el.append(text);
				el.show();
			}
		}
		this.delegateEvents({'click .js-aside-dashboard-actions a' : "onActionClick"});
	},

	onActionClick: function (event)
	{
		$(event.currentTarget).mouseleave();
		var idx = $(event.currentTarget).data('index');
		var action = this.all_actions[idx];
		if (typeof(action) == 'undefined')
			return true;
		if (typeof(action.click) == 'function')
		{
			return action.click(this.collection);
		}

		return true;
	}
});