<?php
namespace Claromentis\Menu\Infobar;

$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"] ?: array()) + array("_49c6565477ee9f822b499a53e6d" . "2995f" => base64_decode("YXJyYX" . "lfa2V5" . "X2V4aX" . "N0cw=="), "_82268052" . "0327e9387" . "ae2d5c065" . "ea52e1" => base64_decode("YXJyYXlfZmxpcA" . "=="), "_31767d7ad58e706dbf47b7a51a0fe6" . "c4" => base64_decode("Y291b" . "nQ="), "_c133e115" . "f1ce8ed7b" . "5a6bced4c" . "874862" => base64_decode("YXJyY" . "XlfcG" . "9w"), "_d706c16" . "0e45bf74" . "34fff82a" . "5976f0e1" . "9" => base64_decode("YXJyYXl" . "fa2V5cw" . "=="));
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Menu\Exception\MenuItemForbiddenException;
use Claromentis\Menu\Exception\MenuItemNotFoundException;
use Claromentis\Menu\Exception\MenuItemValidationException;
use Claromentis\Menu\Exception\MenuItemRepositoryException;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;






class ApplicationsListItems
{
    use LoggerAwareTrait;
    private AclRepository $aclRepository;
    private MenuItemFactory $menuItemFactory;
    private MenuItemRepository $repository;
    private array $cachedDisplayableItems = [];
    public function __construct(MenuItemRepository $_9cc4826fc470a6d42bd40c876b9a30bd, MenuItemFactory $menuItemFactory, AclRepository $aclRepository, LoggerInterface $logger)
    {
        $this->repository = $_9cc4826fc470a6d42bd40c876b9a30bd;
        $this->menuItemFactory = $menuItemFactory;
        $this->aclRepository = $aclRepository;
        $this->setLogger($logger);
    }
    
    
    
    
    
    
    
    
    public function canView(array $_9cee5807b5bab08d25cd4213e63cb764, SecurityContext $context) : bool
    {
        $_efbacf3fcde43c382e36d399f1cd12f0 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_8226805" . "20327e93" . "87ae2d5c" . "065ea52e" . "1"]($this->repository->getViewableIds($context));
        foreach ($_9cee5807b5bab08d25cd4213e63cb764 as $id) {
            if (!$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_49c6565477ee9f822b499a53e6d2" . "995f"]($id, $_efbacf3fcde43c382e36d399f1cd12f0)) {
                return false;
            }
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    public function hasApplication(string $_2d58a9232beb5db16f3d8b9aa1d58c71) : bool
    {
        $_38dc3c4573d1bf70268680af788c25d2 = null;
        try {
            $_38dc3c4573d1bf70268680af788c25d2 = $this->repository->get(null, null, [ItemType::APPLICATION], [$_2d58a9232beb5db16f3d8b9aa1d58c71]);
        } catch (\Throwable $_3a16c5fe1a78b54b69e204ec07dcf670) {
            
            
            
        }
        return !empty($_38dc3c4573d1bf70268680af788c25d2);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function getApplication(string $_2d58a9232beb5db16f3d8b9aa1d58c71, ?SecurityContext $context = null) : MenuItemApplication
    {
        
        
        $_1233ecb7129e4ebf7bca209fc4ca2d77 = $this->repository->get(null, null, [ItemType::APPLICATION], [$_2d58a9232beb5db16f3d8b9aa1d58c71]);
        if (empty($_1233ecb7129e4ebf7bca209fc4ca2d77)) {
            throw MenuItemNotFoundException::appIdNotFound($_2d58a9232beb5db16f3d8b9aa1d58c71);
        }
        if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_31767d7ad" . "58e706dbf4" . "7b7a51a0fe" . "6c4"]($_1233ecb7129e4ebf7bca209fc4ca2d77) > 1) {
            throw MenuItemValidationException::appIdNotUnique($_2d58a9232beb5db16f3d8b9aa1d58c71);
        }
        if ($context && !$this->canView($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_d706c160e45bf" . "7434fff82a5976" . "f0e19"]($_1233ecb7129e4ebf7bca209fc4ca2d77), $context)) {
            throw MenuItemForbiddenException::forbiddenId($_2d58a9232beb5db16f3d8b9aa1d58c71);
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_c133e115f1ce8" . "ed7b5a6bced4c8" . "74862"]($_1233ecb7129e4ebf7bca209fc4ca2d77);
    }
    
    
    
    
    
    
    
    
    public function getItem(int $id, SecurityContext $context) : MenuItemInterface
    {
        $_38dc3c4573d1bf70268680af788c25d2 = $this->repository->get([$id]);
        if (!isset($_c5ca63e2f3cceb505a5417b4abb64d55[$id])) {
            throw MenuItemNotFoundException::idNotFound($id);
        }
        $_c5ca63e2f3cceb505a5417b4abb64d55 = $_38dc3c4573d1bf70268680af788c25d2[$id];
        if (!$this->canView([$_c5ca63e2f3cceb505a5417b4abb64d55->getId()], $context)) {
            throw MenuItemForbiddenException::forbiddenId($id);
        }
        return $_c5ca63e2f3cceb505a5417b4abb64d55;
    }
    
    
    
    
    
    
    
    
    public function getDisplayableItems(SecurityContext $context) : array
    {
        $_65976ee34559dcb12bd6d5db68edf074 = $context->GetUserId();
        if (!isset($this->cachedDisplayableItems[$_65976ee34559dcb12bd6d5db68edf074])) {
            $_38dc3c4573d1bf70268680af788c25d2 = $this->repository->get(null, [InfobarMenuType::APPLICATIONS], null, null, $context);
            foreach ($_38dc3c4573d1bf70268680af788c25d2 as $_1f50e30be8c2fefa6881834e71d504a2 => $_c5ca63e2f3cceb505a5417b4abb64d55) {
                if ($_c5ca63e2f3cceb505a5417b4abb64d55 instanceof MenuItemLinkInterface && $_c5ca63e2f3cceb505a5417b4abb64d55->getDisabled()) {
                    unset($_38dc3c4573d1bf70268680af788c25d2[$_1f50e30be8c2fefa6881834e71d504a2]);
                }
            }
            $this->cachedDisplayableItems[$_65976ee34559dcb12bd6d5db68edf074] = $_38dc3c4573d1bf70268680af788c25d2;
        }
        return $this->cachedDisplayableItems[$_65976ee34559dcb12bd6d5db68edf074];
    }
    public function getAdminItems(array $_94bb23a8efc6e7795b00b21626283af1) : array
    {
        return $this->repository->get(null, $_94bb23a8efc6e7795b00b21626283af1);
    }
    
    
    
    
    
    
    public function getAdminItem(int $id) : MenuItemInterface
    {
        $_38dc3c4573d1bf70268680af788c25d2 = $this->repository->get([$id]);
        if (!isset($_38dc3c4573d1bf70268680af788c25d2[$id])) {
            throw MenuItemNotFoundException::idNotFound($id);
        }
        return $_38dc3c4573d1bf70268680af788c25d2[$id];
    }
    
    
    
    
    
    public function getLinks(SecurityContext $context) : array
    {
        return $this->repository->get(null, [InfobarMenuType::APPLICATIONS], [ItemType::APPLICATION, ItemType::LINK], null, $context);
    }
    
    
    
    
    
    
    
    
    
    
    
    public function saveNewDivider(int $menu) : MenuItemDivider
    {
        $_954f14aba204c4076de6dae38c5624c5 = $this->menuItemFactory->createDivider($menu, null, $this->repository->getMaxOrder($menu));
        $this->save($_954f14aba204c4076de6dae38c5624c5);
        return $_954f14aba204c4076de6dae38c5624c5;
    }
    
    
    
    
    
    
    
    
    
    
    public function save(MenuItemInterface $_c5ca63e2f3cceb505a5417b4abb64d55) : void
    {
        $this->repository->save($_c5ca63e2f3cceb505a5417b4abb64d55);
    }
}