var holiday_cell_width = 10;

function explode(separator, string)
{
	var j, tmp;

	if (separator==null)
		return;

	var result = new Array();

	if (string=='' | string==null)
		return result;

	if (strpos(string, separator)<0) {
		result[0]=string;
		return result;
	}

	//-- errors handled
	tmp = string;
	j=0;

	while (strpos(tmp, separator)>-1) {
		result[j] = tmp.substring(0, strpos(tmp, separator));
		tmp = strDelete(tmp, 0, strpos(tmp, separator) + separator.length);
		j++;
	}

	if (tmp!='')
		result[j] = tmp;

	return result;
}

function implode (glue, pieces)
{
	var i;
	var result = '';
	for (i=0;i<pieces.length;i++)
	{
		if (i == pieces.length-1)
		{
			result = result + pieces[i];
			break;
		}
		result = result + pieces[i] + glue;
	}
	return result;
}

function strpos(haystack, needle)
{
	var i;
	for (i=0;i<=(haystack.length - needle.length);i++)
	{
		if (haystack.substr(i, needle.length) == needle)
			return i;

	}
	return -1;
}
function strDelete(string, start, count)
{
	if (string=='' | count==0)
		return string;

	return string.substring(0, start-1) + string.substring(start+count, string.length);
}

var m_d = false;
var check_stat = true;
document.body.onmouseup = m_up;
function m_down(){
	m_d = true;
}
function m_up(){
	m_d = false;
}
function highlight_day(dayId, on_or_off)
{
	var obj = jQuery('#day_num_row_' + (parseInt(dayId, 10)+1));
	if (on_or_off)
		obj.addClass('hover');
	else
		obj.removeClass('hover');
}
function do_func(userId, dayId, flag){
	if(m_d || flag){
		if(document.getElementById(userId+"_check_"+dayId).checked){
			first = 1;
		}else{
			first = 0;
		}
		if(flag){
			//alert(document.getElementById('check_row_'+userId).style.display);
			//var disp = 'block'; //window.ie ? 'block' : 'table-row';
			jQuery('#check_row_'+userId).show();
			document.getElementById(userId+"_check_"+dayId).checked = 1 - document.getElementById(userId+"_check_"+dayId).checked;
			check_stat = document.getElementById(userId+"_check_"+dayId).checked;
		}else{
			document.getElementById(userId+"_check_"+dayId).checked = check_stat;
		}
		if(document.getElementById(userId+"_check_"+dayId).checked){
			last = 1;
		}else{
			last = 0;
		}
		el = document.getElementById(userId+"_check_"+dayId);
	}
}

day_action = function(ac_name){
	var arr = new Array();
	arr = explode('_', ac_name);
	var collection = document.getElementsByName('day_part');
	if(arr[2] == 0){
		if(collection[1].value == 1){
			collection[1].checked = 1;
		}else{
			collection[0].checked = 1;
		}
	}else{
		collection[0].checked = 1;
	}
	if((arr[2] == 0) || (arr[1] == 0) || arr[0] == -1){
		for(var i=0;i<collection.length;i++){
			collection[i].disabled = 1;
		}
	}else{
		for(var i=0;i<collection.length;i++){
			collection[i].disabled = 0;
		}
	}
	document.getElementById('commit_button').setAttribute('ac_name', arr[0]+'_'+arr[1]+'_');
	popup_show_modal(jQuery('#ac_confirm'));
}

commitAction = function(ac_name){
	collection = document.getElementsByName('day_part');
	for(var i=0;i<collection.length;i++){
		if(collection[i].checked){
			ac_name += collection[i].value;
			document.getElementById('hp_day_part').value = collection[i].value;
		}
	}
	document.getElementById('hp_comment').value = document.getElementById('confirm_comment').value;
	var arr = document.getElementsByName('hp_checkboxes');
	var line = '';
	for(var i=0;i< arr.length; i++){
		if(arr[i].checked){
			line += arr[i].getAttribute('user')+'_'+arr[i].getAttribute('stat')+'_'+arr[i].getAttribute('num')+'_'+arr[i].getAttribute('day')+'_'+arr[i].getAttribute('half')+'|';
		}
	}
	document.getElementById('hp_days_string').value = line+ac_name;
	document.getElementById('hp_zones_form').submit();
}

do_action = function(ac_name){
	if(jQuery('#'+ac_name).hasClass('set-action')) {
		var arr = document.getElementsByName('hp_checkboxes');
		var line = '';
		for(var i=0;i< arr.length; i++){
			if(arr[i].checked){
				line += arr[i].getAttribute('user')+'_'+arr[i].getAttribute('stat')+'_'+arr[i].getAttribute('num')+'_'+arr[i].getAttribute('day')+'_'+arr[i].getAttribute('half')+'|';
			}
		}
		document.getElementById('hp_days_string').value = line+ac_name;
		document.getElementById('hp_zones_form').submit();
	}
}

var g_user_array = new Array();

holidayLine = function(user_array, status_array, styles_array)
{
	this.user_array = user_array;
	this.status_array = status_array;
	this.styles_array = styles_array;
	this.row1 = document.createElement('tr');
	this.row2 = document.createElement('tr');
	jQuery(this.row1).mousedown(m_down);
	this.row2.className = 'boxes-row';
	this.row2.setAttribute('id', 'check_row_'+this.user_array['user_id']);
	this.row2.style.display = 'none';
	this.td = document.createElement('td');
	this.td.innerHTML = this.user_array['user_name'];
	this.td.className = 'text-left';
	this.td.style.textIndent = '5px';
	this.td.setAttribute('UNSELECTABLE', 'on');
	this.td.setAttribute('user_id', this.user_array.user_id);
	g_user_array['user_'+this.user_array.user_id] = this.user_array['user_stat'];

	this.row1.appendChild(this.td);
	this.td = document.createElement('td');
	this.td.onclick = function(){this.parentNode.style.display = 'none';}
	this.td.innerHTML = this.user_array['user_stat'] = this.getStatString(this.user_array['user_stat']);
	this.row2.appendChild(this.td);
	this.getDaysString();
	return this;
}

holidayLine.prototype.getStatString = function(arr){
	if(typeof arr.days != 'undefined'){
		return '';
	}else{
		return '';
	}
}

holidayLine.prototype.checkCache = function(type){
	if(typeof hp_cache == 'undefined') hp_cache = new Array();
	if(typeof hp_cache[type] == 'undefined'){
		hp_save_cache = true;
		return false;
	}
	hp_save_cache = false;
	return hp_cache[type];
}

holidayLine.prototype.writeToCache = function(type, el){
	hp_cache[type] = el;
}

holidayLine.prototype.postProcess = function(el, i){
	el.setAttribute('user_id', this.user_array['user_id']);
	el.setAttribute('day_id', i);
	el.onmousedown = function(event){
		do_func(this.getAttribute('user_id'), this.getAttribute('day_id'), true);
	}
	el.onmouseover = function(event){
		highlight_day(this.getAttribute('day_id'), true);
		do_func(this.getAttribute('user_id'), this.getAttribute('day_id'));
	}
	el.onmouseout = function(event){
		highlight_day(this.getAttribute('day_id'), false);
	}
	return el;
}

holidayLine.prototype.getDaysString = function()
{
	for (var i=0;i<this.status_array.length;i++)
	{
		var td = this.checkCache(this.status_array[i]);
		if (td)
		{
			this.row1.appendChild(this.postProcess(td.cloneNode(1), i));
			var tmp = explode('_', this.status_array[i]);
			this.num = tmp[0];
		} else
		{
			this.td1 = document.createElement('td');
			this.td1.setAttribute('UNSELECTABLE', 'on');
			this.getTdByDayNum(i);
			if(hp_save_cache) this.writeToCache(this.status_array[i], this.td1);
			this.row1.appendChild(this.td1);
			td1 = this.td1;
		}
		this.td2 = document.createElement('td');
		this.td2.setAttribute('UNSELECTABLE', 'on');
		this.td2.innerHTML = this.getSecondaryTd(i);
		this.row2.appendChild(this.td2);
	}
}

holidayLine.prototype.getSecondaryTd = function(num){
	return '<input type="checkbox" stat="'+this.stat+'" half="'+this.half+'" num="'+this.num+'" user="'+this.user_array['user_id']+'" day="'+(num+1)+'" id="'+this.user_array['user_id']+'_check_'+num+'" name="hp_checkboxes" style="margin: -1px;">';
}

holidayLine.prototype.getTdByDayNum = function(num){
	var tmp = new Array();
	var num1 = num;
	var tmp = explode('_', this.status_array[num]);
	this.day_arr = new Array();
	this.day_arr = tmp;
	this.num = tmp[0];
	this.stat = tmp[1];
	if(tmp[2] == 1 || tmp[2] == 2 || tmp[2] == 3){
		this.half = tmp[2];
	}else{
		this.half = 0;
	}
	this.td1.setAttribute('user_id', this.user_array['user_id']);
	this.td1.setAttribute('day_id', num1);
	this.td1.onmousedown = function(event){
		do_func(this.getAttribute('user_id'), this.getAttribute('day_id'), true);
	}
	this.td1.onmouseover = function(event){
		highlight_day(this.getAttribute('day_id'), true);
		do_func(this.getAttribute('user_id'), this.getAttribute('day_id'));
	}
	this.td1.onmouseout = function(event){
		highlight_day(this.getAttribute('day_id'), false);
	}
	// Creating day representation
	if(this.stat == 0){
		this.td1.appendChild(this.createDeclinedSpan1('id_'+this.num, this.half));
		this.td1.appendChild(this.createDeclinedSpan2('id_'+this.num, this.half));
	}
	if(this.stat == 1) this.td1.appendChild(this.createApprovedSpan('id_'+this.num, this.half));
	if(this.stat == 2){
		this.td1.appendChild(this.createRequestedSpan1('id_'+this.num, this.half));
		this.td1.appendChild(this.createRequestedSpan2('id_'+this.num, this.half));
	}
}

holidayLine.prototype.createApprovedSpan = function(num, half){
	this.td1.style.background = this.styles_array[num][2];
	this.span = document.createElement('span');
	this.span.setAttribute('UNSELECTABLE', 'on');
	this.span.className = 'approved-day';
	this.span.style.color = this.styles_array[num][1];
	this.span.innerHTML = this.styles_array[num][0];
	return this.span;
}

holidayLine.prototype.createDeclinedSpan1 = function(num, half){
	this.td1.style.background = this.styles_array[num][2];
	this.span = document.createElement('span');
	this.span.setAttribute('UNSELECTABLE', 'on');
	this.span.className = 'declined-day1';
	this.span.innerHTML = '!';
	return this.span;
}
holidayLine.prototype.createDeclinedSpan2 = function(num, half){
	this.span = document.createElement('span');
	this.span.setAttribute('UNSELECTABLE', 'on');
	this.span.style.color = 'black';
	this.span.innerHTML = this.styles_array[num][0];
	return this.span;
}

holidayLine.prototype.createRequestedSpan1 = function(num, half){
	this.td1.style.background = this.styles_array[num][2];
	this.span = document.createElement('span');
	this.span.setAttribute('UNSELECTABLE', 'on');
	this.span.className = 'requested-day1';
	this.span.innerHTML = '?';
	return this.span;
}
holidayLine.prototype.createRequestedSpan2 = function(num, half){
	this.span = document.createElement('span');
	this.span.setAttribute('UNSELECTABLE', 'on');
	this.span.style.color = this.styles_array[num][1];
	this.span.innerHTML = this.styles_array[num][0];
	return this.span;
}

holidayLine.prototype.getRowHeader = function(){
	var text = "<tr><td>"+this.user_array['user_name']+"</td><td>"+this.user_array['user_stat']['quota']+"</td>";
	return text;
}


dayNumRow = function(col_name, num){
	this.row = document.createElement('tr');
	this.row.className = 'num-row';
	this.td = document.createElement('td');
	this.td.innerHTML = col_name;
	this.td.className = 'text-left';
	this.td.style.textIndent = '5px';
	this.row.appendChild(this.td);

	for(i=0;i<num;i++){
		this.td = document.createElement('td');
		this.td.innerHTML = i+1;
		this.td.id = 'day_num_row_' + (i+1);
		this.row.appendChild(this.td);
	}
	return this.row;
}

tableColGroup = function(num, width){
	this.colgroup = document.createElement('colgroup');
	this.col = document.createElement('col');
	this.col.className = 'first_num_col';
	this.colgroup.appendChild(this.col);
	this.col = document.createElement('col');
	this.col.className= 'day-num-col';
	this.col.setAttribute('span', num );
	this.colgroup.appendChild(this.col);

	return this.colgroup;
}

rowSeparator = function(row_name,num){
	this.row = document.createElement('tr');
	this.row.className = 'theading';
	this.td = document.createElement('td');
	this.td.setAttribute('colspan', num);
	this.td.colSpan = num;
	this.td.innerHTML = row_name;
	// this.td.appendChild(this.nameSpan);
	this.row.appendChild(this.td);
	return this.row;
}

rowAction = function(day_style, num, flag){
	var compiled,
		template,
		prefix = 'Approved';

 	if(num == 2 || num == 3 || num == 4 ){
 		prefix = '';
 	}
	compiled = _.template('<a class="btn btn-secondary set-action mb-1 mb-md-0" href="#" id="action_1_{{= data.id }}" onclick="do_action(\'action_1_{{= data.id }}\');">' +
		'  <div class="calendar-day approved-day" style="color: {{= data.color }}; border-color: {{= data.borderColor }}; background-color: {{= data.backgroundColor }}">'+
		'    {{= data.label }}'+
		'  </div>' +
		'  {{= data.text }}' +
		'</a> ');

	template = compiled({
		data : {
			backgroundColor : day_style[2],
			borderColor: day_style[2],
			color: day_style[1],
			label: day_style[0],
			id: num,
			text: prefix + day_style[3]
		}
	});

	$('#day_actions').append(template);
}


createZoneList = function (data){
	var month_num = data[0]['cur_year'].length;
	var styles_array = zones_styles_array;
	rowAction(styles_array['id_4'], 4, 0);
	rowAction(styles_array['id_3'], 3, 0);

	var table = document.createElement('table');
	table.className = 'table table-bordered hp-string';
	table.setAttribute('width', '100%');
	table.appendChild(tableColGroup(month_num, holiday_cell_width));
	//table.style.tableLayout = 'fixed';
	tbody = document.createElement('tbody');
	table.appendChild(tbody);
	tbody.appendChild(dayNumRow(document.lc['holidays.admin.zones_holidays'], month_num));
	for(var i=0;i<data.length;i++)
	{
		tbody.appendChild(rowSeparator(data[i]['name'], month_num+1));
		var user_array = new Array();
		user_array['user_id'] = data[i]['id'];
		user_array['user_name'] = document.lc['holidays.current_year'];
		user_array['user_stat'] = '';
		var line = new holidayLine(user_array, data[i]['cur_year'], styles_array);
		tbody.appendChild(line.row1);
		tbody.appendChild(line.row2);
		var user_array1 = new Array();
		user_array1 = user_array;
		user_array1['user_name'] = document.lc['holidays.every_year'];
		user_array1['user_id'] = -data[i]['id'];
		var line2 = new holidayLine(user_array1, data[i]['every_year'], styles_array);
		tbody.appendChild(line2.row1);
		tbody.appendChild(line2.row2);
	}
	document.getElementById('test_div').appendChild(table);
}

function prepare_filter_info(){
	var checked_string = hp_tree.getAllChecked();
	document.getElementById('hp_groups').value = checked_string;
	jQuery.cookie('hp_groups_checked', checked_string);
}

function restore_checked(){
	var groups = jQuery.cookie('hp_groups_checked');
	var gr_arr = new Array();
	gr_arr = explode(",", groups);
	for(var i=0;i<gr_arr.length;i++){
		if(hp_tree.getItemText(gr_arr[i]))
			hp_tree.setCheck(gr_arr[i], 1);
	}
}

createGroupPatternString = function (data){
	var month_num = data['days'].length;
	var styles_array = days_styles_array;

	table = document.createElement('table');
	table.className = 'table table-bordered hp-string';
	table.setAttribute('width', '100%');
	table.appendChild(tableColGroup(month_num, holiday_cell_width));
	tbody = document.createElement('tbody');
	table.appendChild(tbody);
	tbody.appendChild(dayNumRow(document.lc['calendar.common.month'], month_num));
		tbody.appendChild(rowSeparator(data['name'], month_num+1));
		var user_array = new Array();
		user_array['user_id'] = data['id'];
		user_array['user_name'] = document.lc['calendar.common.month'];
		user_array['user_stat'] = '';
		var line = new holidayLine(user_array, data['days'], styles_array);
		tbody.appendChild(line.row1);
		tbody.appendChild(line.row2);
	document.getElementById('test_div').appendChild(table);
}
