<?php
namespace Claromentis\Gallery;

$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"] ?: array()) + array();
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Security\SecurityContext;
class GalleryPermissions
{
    const PERM_GALLERY_ALBUM_ADD = 2;
    const PERM_GALLERY_MANAGE = 5;
    const PERM_ALBUM_VIEW = PERM_VIEW;
    const PERM_ALBUM_EDIT = PERM_ALBUM_EDIT;
    const PERM_ALBUM_DELETE = PERM_ALBUM_DELETE;
    const PERM_ALBUM_TAGS = PERM_ALBUM_TAGS;
    const PERM_ALBUM_DEFAULT_RIGHTS = PERM_VIEW | PERM_EDIT | PERM_EDIT_META | PERM_DELETE;
    protected $security;
    protected $acl_object;
    protected $repository;
    protected $isSuperAdmin;
    public function __construct(SecurityContext $_2cbd765e1b06b01f54ce098970fb1499, AclRepository $_8652ba33e6ffeba02459fa9cbb320851, ACL $_900418835ebd998d22745883712223d4)
    {
        $this->acl_object = $_900418835ebd998d22745883712223d4;
        $this->repository = $_8652ba33e6ffeba02459fa9cbb320851;
        $this->security = $_2cbd765e1b06b01f54ce098970fb1499;
        $this->isSuperAdmin = $this->acl_object->Permits($this->security, self::PERM_GALLERY_MANAGE);
    }
    public function CanIManageAlbums()
    {
        return $this->isSuperAdmin;
    }
    public function CanIAddAlbum()
    {
        return $this->acl_object->Permits($this->security, self::PERM_GALLERY_ALBUM_ADD);
    }
    public function CanIManageTags($_3ae282782bba85e26a8e3624b21a4bcc)
    {
        return $this->AlbumPermissions($_3ae282782bba85e26a8e3624b21a4bcc, self::PERM_ALBUM_TAGS);
    }
    public function CanIDeleteAlbum($_3ae282782bba85e26a8e3624b21a4bcc)
    {
        return $this->AlbumPermissions($_3ae282782bba85e26a8e3624b21a4bcc, self::PERM_ALBUM_DELETE);
    }
    public function CanIEditAlbum($_3ae282782bba85e26a8e3624b21a4bcc)
    {
        return $this->AlbumPermissions($_3ae282782bba85e26a8e3624b21a4bcc, self::PERM_ALBUM_EDIT);
    }
    public function CanIViewAlbum($_3ae282782bba85e26a8e3624b21a4bcc)
    {
        return $this->AlbumPermissions($_3ae282782bba85e26a8e3624b21a4bcc, self::PERM_ALBUM_VIEW);
    }
    public function GetDefaultRights()
    {
        return self::PERM_ALBUM_DEFAULT_RIGHTS;
    }
    protected function AlbumPermissions($_3ae282782bba85e26a8e3624b21a4bcc, $_1ac701da0834eb6c188cf3ef004a1aca)
    {
        if ($this->isSuperAdmin) {
            return true;
        }
        $acl = new ACL(PERM_CLASS_GALLERY_ALBUM, $_3ae282782bba85e26a8e3624b21a4bcc);
        $this->repository->Load($acl);
        return $acl->Permits($this->security, $_1ac701da0834eb6c188cf3ef004a1aca);
    }
}