define(['jquery', 'domReady'], function (jQuery, domReady) {
    domReady(function () {

        jQuery('body').on('click', '.js-like-component .js-like-it', function (event) {
            event.preventDefault();

            var component_tag = jQuery(this).closest('.js-like-component');

            var object_type = component_tag.data('object-type');
            var object_id = component_tag.data('object-id');

            var spinner = jQuery('.js-loading-spinner', component_tag);
            spinner.show();

            jQuery.ajax({
                method: 'PUT',
                url: '/api/like/' + object_type + '/' + object_id + '/me',
                dataType: 'json',
                success: function (data) {
                    spinner.hide();
                    jQuery('.js-liked', component_tag).hide();
                    jQuery('.js-unliked', component_tag).show();
                    jQuery('.js-like-count', component_tag).text(lmsg('common.like.x_people_liked', data.total));
                }
            });
        })

        .on('click', '.js-like-component .js-unlike-it', function (event) {
            event.preventDefault();

            var component_tag = jQuery(this).closest('.js-like-component');

            var object_type = component_tag.data('object-type');
            var object_id = component_tag.data('object-id');

            var spinner = jQuery('.js-loading-spinner', component_tag);
            spinner.show();

            jQuery.ajax({
                method: 'PUT',
                url: '/api/like/' + object_type + '/' + object_id + '/me/unlike',
                dataType: 'json',
                success: function (data) {
                    spinner.hide();
                    jQuery('.js-liked', component_tag).show();
                    jQuery('.js-unliked', component_tag).hide();
                    jQuery('.js-like-count', component_tag).text(lmsg('common.like.x_people_liked', data.total));
                }
            });
        })

        .on('click', '.js-like-component .js-likers', function (event) {
            event.preventDefault();

            var component_tag = jQuery(this).closest('.js-like-component');

            var object_type = component_tag.data('object-type');
            var object_id = component_tag.data('object-id');

            var spinner = jQuery('.js-loading-spinner', component_tag);
            spinner.show();

            jQuery.ajax({
                method: 'GET',
                url: '/api/like/' + object_type + '/' + object_id + '/html',
                dataType: 'html',
                success: function (data) {
                    var el = jQuery('#likers-modal');
                    el.detach();
                    $('body').append(el);
                    jQuery('.js-likers-list', el).html(data);
                    el.modal();
                    spinner.hide();
                }
            });
        });
    });
});
