<?php
$_db_migration_to = '31.01'; // 8.5.0-rc
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_add_sudo_uid_to_audit_log.php', <<<'DB_UPDATE_FILE'
<?php
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");


$db->AddColumn('audit_log_txt', 'sudo_userid', "INT NULL");
//$db->query("UPDATE audit_log_txt SET sudo_userid = userid");

$db->AddColumn('ERMS_audit_log_txt', 'sudo_userid', "INT NULL");
//$db->query("UPDATE ERMS_audit_log_txt SET sudo_userid = userid");

DB_UPDATE_FILE
);


$migrations->Run('01_document_comments_to_discuss.php', <<<'DB_UPDATE_FILE'
<?php
// Documents now uses the discuss comments engine instead of the old comments
// engine. This migration moves old comments into discuss

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query("INSERT INTO discussions (user_id, object_id, ancillary, aggregation, parent_id, attachment_id, txt, timestamp, like_count, reply_count)
	SELECT user_id, object_id, status, aggregation, 0, 0, comment_text, date_created, 0, 0 FROM comments WHERE aggregation = 4");


DB_UPDATE_FILE
);


$migrations->Run('01_in_system_triggers.php', <<<'DB_UPDATE_FILE'
<?php
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$db->AddColumn('hd_trigger','in_system','BOOL NOT_NULL DEFAULT 0');

DB_UPDATE_FILE
);


$migrations->Run('02_create_timers.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$tableInfo = [
	'id' => 'IDENTITY',
	'name' => 'VARCHAR(255)',
	'project_id' => "INT NOT_NULL",
	'field_name' => 'VARCHAR(80)',
	'duration' => 'VARCHAR(255)',
	'repetition' => 'VARCHAR(255)'
];

$db->CreateTable('hd_timers', $tableInfo);

$tableInfo = [
	'project_id' => 'INT NOT_NULL',
	'ticket_id' => 'INT NOT_NULL',
	'timer_id' => 'INT NOT_NULL',
	'threshold' => 'INT_DATE NOT_NULL'
];

$db->CreateTable('hd_timer_thresholds', $tableInfo);

$db->CreatePrimaryKey('hd_timer_thresholds', 'project_id', 'ticket_id', 'timer_id');

DB_UPDATE_FILE
);


$migrations->Run('03_timer_primary_key.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropPrimaryKey('hd_timer_thresholds');
$db->AddColumn('hd_timer_thresholds', 'id', 'IDENTITY');

DB_UPDATE_FILE
);


$migrations->Run('04_remove_recurrence.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropColumn('hd_timers', 'repetition');

DB_UPDATE_FILE
);


$migrations->Run('05_create_timer_issue_join.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$table_info = [
	'id' => 'IDENTITY',
	'issue_id' => 'INT',
	'timer_id' => 'INT',
	'flag_value' => 'BOOL NOT_NULL'
];

$db->CreateTable('hd_issue_timers', $table_info);

DB_UPDATE_FILE
);


$migrations->Run('06_threshold_in_join.php', <<<'DB_UPDATE_FILE'
<?php
use Claromentis\Core\DAL;
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('hd_issue_timers', 'threshold', 'INT_DATE');

$db->DropTable('hd_timer_thresholds');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('31.01');
