showOpt = function(name){

	if(name != 'room') document.getElementById('room_popup').style.display = 'none';
	if(name != 'fac') document.getElementById('fac_popup').style.display = 'none';
	if(name != 'date') document.getElementById('date_popup').style.display = 'none';
	//document.getElementById('').style.display = 'none';
	if(document.getElementById(name+'_popup').style.display == 'none'){
		document.getElementById(name+'_popup').style.display = 'block';
		if(name == 'date') initDateForm('date');
	}else{
		document.getElementById(name+'_popup').style.display = 'none';
	}

	checkObjStatus(name);
}

initDateForm = function(context){
	repView(document.getElementById('date_repetition').checked, context);
	el = document.getElementById('rep_type_select');
	el.options[el.selectedIndex].onclick();
}

checkObjStatus = function(name){
	if(name != 'date'){
		var collection = document.getElementsByTagName('input');
		var stat = false;
		for (i = 0; i < collection.length; i++)
		{
			var item=collection[i];
			if (item.name.indexOf(name+'_obj_check')>=0)
			{
				if(item.checked) stat = true;
			};
		}
		//document.getElementById(name+'_link').innerHTML = getName(name, stat);
	}
}

getName = function(name, stat){
	var link_text;
	switch(name){
		case 'room' : (stat) ? link_text = loc['sel_rooms'] : link_text = loc['any_rooms']; break;
		case 'fac' : (stat) ? link_text = loc['with_fac'] : link_text = loc['no_fac']; break;
	}
	return link_text;
}

repView = function(stat, context){
	if(context == 'date')(stat) ? document.getElementById('rep_block').style.display = '' : document.getElementById('rep_block').style.display = 'none';
	if(context == 'calendar'){
		(stat) ? document.getElementById('rep_block').style.display = '' : document.getElementById('rep_block').style.display = 'none';
	}
}

setWholeDay = function(stat){
	if (stat){
		document.getElementById('start_time').style.display = 'none';
		document.getElementById('start_time').value = '00:00';
		document.getElementById('end_time').style.display = 'none';
		document.getElementById('end_time').value = '23:59';
	}else{
		document.getElementById('start_time').style.display = '';
		document.getElementById('end_time').style.display = '';
	}
}

timeView = function(stat){
	(!stat) ? document.getElementById('time_block').style.display = '' : document.getElementById('time_block').style.display = 'none';
}

advRepView = function(block, el){
	jQuery('#week_block').removeClass('visible_table_row');
	jQuery('#week_block').addClass('d-none');
	if (block == 'none') return;
	el.selected = true;
	jQuery('#'+block+'_block').removeClass('d-none');
	jQuery('#'+block+'_block').addClass('visible_table_row');
}

addToCalendar = function(room_id){
	var o_form = opener.document.forms.calEventForm;
	opener.document.getElementById('ProjectAddNewCourseDate').enableForm();
	var collection = document.getElementsByTagName('input');
	for (i = 0; i < collection.length; i++)
	{
		var item = collection[i];
		var name=item.name;
		if (name.indexOf('date_date')>=0)
		{
			str = name.replace('date_date', 'calendar_date');
			o_form[str].value = item.value;
			if(item.checked){
				o_form[str].checked = item.checked;
				if(o_form[str].onclick) o_form[str].onclick();
			}else{
				o_form[str].checked = false;
				if(o_form[str].onclick) o_form[str].onclick();
			}
		};
	}
	var collection = document.getElementsByTagName('select');
	for (i = 0; i < collection.length; i++)
	{
		var item = collection[i];
		var name=item.name;
		if (name.indexOf('date_date')>=0)
		{
			str = name.replace('date_date', 'calendar_date');
			o_form[str].options[item.selectedIndex].selected = true;
			o_form[str].options[item.selectedIndex].onclick();
		};
	}
	 opener.document.getElementById('room_id').value = room_id;
	 opener.document.getElementById('room_name').innerHTML = document.rb_data['room']['room_'+room_id]['name'];
	 opener.document.getElementById('location').value = document.rb_data['room']['room_'+room_id]['name'];
	 opener.document.getElementById('fac_ids').value = document.rb_data['fac_ids'];
	 opener.document.getElementById('fac_list').innerHTML = document.rb_data['fac_str'];
	 opener.document.getElementById('ProjectAddNewCourseDate').disableForm();
	 window.close();
}

displayAddEvent = function(room_id, stat){
	if(title = window.opener.document.getElementById('event_title')){
		document.getElementById('event_name').value = title.value;
		document.getElementById('event_desc').value = window.opener.document.getElementById('event_description').value;
	}
	document.getElementById('event_info_block').removeClass('d-none');
	var newLeft = getCenterX(400);
	var newTop = getCenterY(350);
	var el = document.getElementById('add_event_block');
	el.style.top = newTop+'px';
	el.style.left = newLeft+'px';
	el.style.display = '';
	document.getElementById('ri_anytime').style.display = (!stat) ? 'none' : '';
	document.getElementById('ri_not_available').style.display = (!stat) ? 'block' : 'none';
}

displayHelpTopic = function(){
	document.getElementById('event_info_block').addClass('d-none');
	document.getElementById('add_event_block').style.display = 'none';
	var newLeft = getCenterX(500);
	var newTop = getCenterY(600);
	var el = document.getElementById('help_event_block');
	el.style.top = newTop+'px';
	el.style.left = newLeft+'px';
	el.style.display = '';
}

var isIE = document.all;
var mouseX = 0;
var mouseY = 0;

function getMouseXY(e){
	if (!e) e = window.event;
	if (e){
		mouseX = isIE ? (e.clientX + document.body.scrollLeft) : e.pageX;
		mouseY = isIE ? (e.clientY + document.body.scrollTop) : e.pageY;
	}
}

document.onmousemove = getMouseXY;


function displayEventInfo(event_id, target_el, mousemove){
	document.getElementById('add_event_block').style.display = 'none';
	var el = jQuery('#event_info_block');

	if (!document.rb_data['date'])
	{
		alert("Internal error, no events info loaded");
		return;
	}
	if (!document.rb_data['date']['date_'+event_id])
	{
		alert("Internal error. Details of event "+event_id+" not loaded");
		return;
	}

	el.removeClass('d-none');

	rep = 0;
	document.getElementById('eid_value').value = event_id;
	document.getElementById('ei_event_status').innerHTML = document.rb_data['date']['date_'+event_id]['status'];
	//document.getElementById('ei_event_rep').innerHTML = document.rb_data['date']['date_'+event_id]['repetition'];
	document.getElementById('owner_tr').style.display = 'none';
	if (document.rb_data['date']['date_'+event_id]['booked_by'])
	{
		document.getElementById('booked_by').innerHTML =
			document.rb_data['date']['date_'+event_id]['booked_by'];
		document.getElementById('booked_by').href =
			"/intranet/people/viewprofile.php?id="+document.rb_data['date']['date_'+event_id]['booked_by_id'];
		document.getElementById('behalf_span').style.display = '';
		document.getElementById('on_behalf_of').innerHTML = document.rb_data['date']['date_'+event_id]['owner'];
		document.getElementById('on_behalf_of').href = "/intranet/people/viewprofile.php?id="+document.rb_data['date']['date_'+event_id]['owner_id'];
	} else
	{
		document.getElementById('booked_by').innerHTML = document.rb_data['date']['date_'+event_id]['owner'];
		document.getElementById('booked_by').href = "/intranet/people/viewprofile.php?id="+document.rb_data['date']['date_'+event_id]['owner_id'];
		document.getElementById('behalf_span').style.display = 'none';
	}
	document.getElementById('ei_event_owner').setAttribute('target', 'blank');
	var count = document.rb_data['room']['room_'+document.rb_data['date']['date_'+event_id]['room']]['count'];
	var cap_el = document.getElementById('room_capacity');
	if (cap_el)
		cap_el.innerHTML = (100000 == count) ? '--' : count;
	jQuery('#ei_event_name').text(document.rb_data['date']['date_'+event_id]['name']);
	document.getElementById('ei_date_range').innerHTML = document.rb_data['date']['date_'+event_id]['period']+
		' '+document.rb_data['date']['date_'+event_id]['repetition'];
	jQuery('#ei_event_fac').text(document.rb_data['date']['date_'+event_id]['fac']);
	jQuery('#ei_event_room_name').text(document.rb_data['date']['date_'+event_id]['room_name'] ? document.rb_data['date']['date_'+event_id]['room_name'] : '--');
	document.getElementById('ei_event_desc').innerHTML = document.rb_data['date']['date_'+event_id]['desc'] == 0 ? '' : document.rb_data['date']['date_'+event_id]['desc'];
	if (document.rb_data['user_id'] == document.rb_data['date']['date_'+event_id]['owner_id']) {
		var parentNodeEl = document.getElementById('ei_event_del').parentNode;
		if (parentNodeEl.style.display == 'none') {
			parentNodeEl.style.display = '';
		}
		document.getElementById('ei_event_edit').href = '#';
		document.getElementById('ei_event_del').href = "?g_action=delete_event&event_id="+event_id;
	}else{
		var parentNodeEl = document.getElementById('ei_event_del').parentNode;
		parentNodeEl.style.display = 'none';
	}
}

newStartDate = function(string){
	document.getElementById('date_point').value = string;
	document.getElementById('start_date').value = string;
	document.getElementById('end_date').value = string;
}

newStartTime = function(string){
	document.getElementById('end_time').value = string;
}

eventAction = function(action){
	switch(action){
		case 'delete' :
				document.getElementById('ei_help_status').value="delete_event";
				document.getElementById('ei_action').value="delete_event";
				document.getElementById('ei_form').submit();
			break;
		case 'delete_sequence' :
				if(document.rb_data['date']['date_'+document.getElementById('eid_value').value]['pid'] != -1)
					document.getElementById('eid_value').value = document.rb_data['date']['date_'+document.getElementById('eid_value').value]['pid'];
				document.getElementById('ei_help_status').value="";
				document.getElementById('ei_action').value="delete_event";
				document.getElementById('ei_form').submit();
			break;
		case 'edit' :
				document.getElementById('ei_help_status').value="edit_event";
				document.getElementById('ei_action').value="edit_event";
				document.getElementById('ei_form').submit();
			break;
		case 'edit_sequence' :
				if(document.rb_data['date']['date_'+document.getElementById('eid_value').value]['pid'] != -1)
					document.getElementById('eid_value').value = document.rb_data['date']['date_'+document.getElementById('eid_value').value]['pid'];
				document.getElementById('ei_help_status').value="edit_event";
				document.getElementById('ei_action').value="edit_event";
				document.getElementById('ei_form').submit();
			break;
	}
}

getCenterX = function(x){
	var ie=document.all && !window.opera
	var dom=document.getElementById
	iebody=(document.compatMode=="CSS1Compat")? document.documentElement : document.body
	var docwidth=(ie)? iebody.clientWidth : window.innerWidth
	var objwidth=400
	var newLeft = docwidth/2-objwidth/2
	if(newLeft <= 0) newLeft = 10;
	return newLeft
}

getCenterY = function(y){
	var ie=document.all && !window.opera
	var dom=document.getElementById
	iebody=(document.compatMode=="CSS1Compat")? document.documentElement : document.body
	var scroll_top=(ie)? iebody.scrollTop : window.pageYOffset
	docheight=(ie)? iebody.clientHeight: window.innerHeight
	var objheight=y
	var newTop = scroll_top+docheight/2-objheight/2
	if(newTop <= 0) newTop = 10;
	return newTop
}
calEventSelectRoom = function(){
	cal_room = window.open('', 'cal_room', 'width=750,height=580,top=100,left=200,scrollbars=yes');
	document.getElementById('date_point').value = document.getElementById('start_date').value;
	//document.getElementById('calEventForm').setAttribute('target', 'new');
	document.getElementById('calEventForm').target = 'cal_room';
	//document.getElementById('calEventForm').setAttribute('action', 'room_booking_local.php');
	document.getElementById('calEventForm').action = 'rb_start_book.php';
	jQuery('#ProjectAddNewCourseDate').enableForm();
	document.getElementById('calEventForm').submit();
	jQuery('#ProjectAddNewCourseDate').disableForm();
	//document.getElementById('calEventForm').setAttribute('target', '_self');
	document.getElementById('calEventForm').target = '_self';
	//document.getElementById('calEventForm').setAttribute('action', '?');
	document.getElementById('calEventForm').action = '?';
}
checkRoom = function(el){
	if(!(jQuery('#room_id').length>0) || !(el).length>0){return;}
	if(!el.prop('checked') && jQuery('#room_id').val() > 0 ){
		if (confirm('You will lose current link if you do this. Are you sure?') ){
			document.getElementById('room_id').value = '';
		}else{
			el.checked = true;
			return;
		}
	}
	if (!(document.getElementById('sel_room')).length>0 ){return;}
	document.getElementById('sel_room').prop('disabled', !el.prop('checked'));
	if (!el.prop('checked')){
		jQuery('#ProjectAddNewCourseDate').enableForm();
	}else{
		jQuery('#ProjectAddNewCourseDate').disableForm();
	}
}

function diagramToList()
{
	document.getElementById('list_view').className = 'selected';
	document.getElementById('diagram_view').className = '';
	document.getElementById('DesignDiagram').style.display = 'none';
	document.getElementById('DesignList').style.display = '';
	if (jQuery('event_info_block').length>0) jQuery('#event_info_block').addClass('d-none');
	document.getElementById('view_mode').value = 1;
}

function listToDiagram()
{
	//document.getElementById('list_view').className = '';
	//document.getElementById('diagram_view').className = 'selected';
	var dd = document.getElementById('DesignDiagram');
	if (dd.style.display == 'none')
		dd.style.display = '';
	else
		dd.style.display = 'none';
}
