define(['../functions/parseConfigItem'], function(parseConfigItem){
    return function() {
        var ctrl = this;

        this.$onInit = function() {
            ctrl.showEdit = false;
        };

        ctrl.parse = function(type, value){
            var newValue = parseConfigItem(type, value);
            // We insert a non-breaking space here because it's the simplest way of preventing
            // the box from collapsing to zero height and being unclickable
            if(newValue === '' || newValue === null)
                newValue = '\xa0';
            return newValue;
        };
    }
});
