<?php
namespace Claromentis\Core\DAL\SQLite;

$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"] = (@$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"] ?: array()) + array();
use Claromentis\Core\DAL;
use SQLite3Result;




class SQLiteResult implements DAL\ResultInterface
{
    
    
    
    
    protected $res;
    
    
    
    
    protected $current_row;
    
    
    
    
    protected $num_rows;
    
    
    
    
    
    
    public function __construct(SQLite3Result $_1f24efd4735b7a11b391147435e7d35d = null)
    {
        $this->res = $_1f24efd4735b7a11b391147435e7d35d;
        $this->num_rows = 0;
        
        
        if (isset($this->res) && $this->res->numColumns() > 0) {
            while ($this->res->fetchArray()) {
                ++$this->num_rows;
            }
            $this->res->reset();
        }
        $this->current_row = 0;
    }
    protected function doFetch($_b0cf8216499408f540e9d36fba2f4972)
    {
        if ($this->hasData()) {
            ++$this->current_row;
            return DAL\DbUtil::UTF8Fix($this->res->fetchArray($_b0cf8216499408f540e9d36fba2f4972));
        } else {
            return null;
        }
    }
    public function fetchRow()
    {
        return $this->doFetch(SQLITE3_NUM);
    }
    public function fetchArray()
    {
        return $this->doFetch(SQLITE3_ASSOC);
    }
    public function fetchAllValues()
    {
        $_f274035cf280fb57c0c9ef54d849a83d = DAL\DbUtil::fetchAllValues($this);
        
        
        $this->res->reset();
        $this->current_row = 0;
        return $_f274035cf280fb57c0c9ef54d849a83d;
    }
    public function fetchSingleValue()
    {
        if ($this->hasData()) {
            $this->res->reset();
            list($_c96f552040dea8086bf8bdd70059542f) = $this->fetchRow();
            return $_c96f552040dea8086bf8bdd70059542f;
        } else {
            return null;
        }
    }
    public function hasData()
    {
        if (!isset($this->res)) {
            return false;
        }
        $_9d271302b052ffdfe76f3f15bfcd5ade = $this->res->numColumns();
        return $_9d271302b052ffdfe76f3f15bfcd5ade > 0 && $this->num_rows > 0;
    }
    public function free()
    {
        if (isset($this->res)) {
            $this->res->finalize();
        }
    }
    public function numRows()
    {
        return $this->num_rows;
    }
}