require('script-loader!../../web/intranet/js/cla_lib.js');
require('script-loader!../../web/intranet/js/popups.js');
require('../../web/intranet/js/dates.js');

var urlArgs = '';

// Load the version file so we can use the version number for cache busting
var versionTxt = require('raw-loader!../../web/intranet/setup/_init/version.txt');

if (typeof versionTxt === 'string') {
    var versionTxtLines = versionTxt.split('\n');

    if (versionTxtLines[1]) {
        // Replace any characters in the version string other than
        // alphanumerics, dashes, and dots
        urlArgs += 'v=' + versionTxtLines[1].replace(/[^\dA-Za-z-.]/g, '-');
    }
}

var components = {
    "packages": [
        {
         "name": "jquery.tablednd",
         "main": "../../intranet/js/jquery.tablednd.js"
        }
    ],
    "baseUrl": "/components",
    "urlArgs": urlArgs,
    "waitSeconds" : 30
};

if (typeof window.require !== "undefined" && window.require.config) {
    window.require.config(components);
} else {
    window.require = components;
}

window.define('domReady', [], function () {
    return require('./lib/requirejs/domReady.js');
});

window.define('jquery', [], function () {
    return window.jQuery;
});
window.define('jquery-ui/core', [], function () {
    return null;
});
window.define('jquery-ui/widget', [], function () {
    return null;
});
window.define('jquery-ui/mouse', [], function () {
    return null;
});
window.define('jquery-ui/draggable', [], function () {
    return null;
});
window.define('jquery-ui/resizable', [], function () {
    return null;
});
