<?php
namespace Claromentis\Core\User\Directory\Ldap;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] = (@$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] ?: array()) + array("_c906bc81dd9c0320ed" . "e9a60004ee65af" => base64_decode("d2luMjA" . "wMF9kb2" . "1haW4="), "_c230c83684d3ea5d367c6d86c16c0" . "431" => base64_decode("eC11c2Vyb" . "mFtZQ=="), "_d706c160e45bf7434fff" . "82a5976f0e19" => base64_decode("YXJyYX" . "lfa2V5" . "cw=="), "_5ff1b1d6" . "6ba406be9" . "18cf9d21d" . "95d870" => base64_decode("TERBUCBlc" . "nJvcjog"), "_d155d43a39de93f85812" . "3c6b6ce31d8a" => base64_decode("cHJlZ" . "19tYX" . "RjaA=" . "="), "_094a90ab5fdba7fad8a6b" . "3c2c7287bbf" => base64_decode("bnQ0X2RvbWFpbg" . "=="), "_ca5863bab59cc6beb91e242910" . "44d42a" => base64_decode("bWVtYmVyb2" . "Y="), "_e608e5b5c4c34a67ba97ef84c1e1" . "6199" => base64_decode("J" . "w" . "=" . "="), "_70979d287fa2c98d21aa07834c259a5" . "2" => base64_decode("c3Ry" . "dG9s" . "b3dl" . "cg=="), "_ef0abf4494e1bd7519b5603ea9e241" . "fc" => base64_decode("RmFpbGVkIHRvIGxvZ2luIHRvIExEQVAgc2Vy" . "dmVyOiA="), "_f73dab606630b38" . "8645c4f7d3fbb13b" . "b" => base64_decode("YXJyYX" . "lfbWVy" . "Z2U="), "_e4cff6b522" . "04dc59b3dc7" . "f210b3150d3" => base64_decode("IGlzIG5vdCBhIG1lbWJl" . "ciBvZiBhbGxvd2VkIExE" . "QVAgZ3JvdXAocykgYW5k" . "IE9Vcw=="), "_1bee3d4d1d0df49e0f" . "cf8b9ed2ecb8fa" => base64_decode("ZXhwbG9k" . "ZQ=="), "_af50df82a057b10a621d4" . "76dcfd58b99" => base64_decode("IWdyb3Vw" . "cw=="), "_9777893780444e" . "799e6e71df93155" . "6d0" => base64_decode("R2V0VXNlckROIHVzZX" . "JuYW1lOiA="), "_9d799ff31" . "3bcf1dd5c1" . "7f004da40f" . "231" => base64_decode("VXNlci" . "A="), "_a9148efa" . "986a9a8d8" . "f1f5281c6" . "edf49e" => base64_decode("VXNlciBhY2NvdW50IGlzIGRpc2FibGVkIG" . "luIExEQVA="), "_aed8da0f19091214b78f803510" . "48517c" => base64_decode("c3" . "Ry" . "bG" . "Vu"), "_4298577e41894bcce23f896cd365ae" . "a4" => base64_decode("ZW" . "4="), "_7a6839269cdf25d87" . "5660c6a857fbf8d" => base64_decode("L1tcZFx3XSs" . "9W1xkXHddKy" . "Qv"), "_ef19287a2ea5e1fa7552d942c147" . "52f9" => base64_decode("eC1kbg=" . "="), "_12223d821ca3" . "3ae8d28c4447e" . "3eaf058" => base64_decode("Tm8gdXNlcm5hbWUgZ2l" . "2ZW4="), "_8f65c3c384b75" . "d89f9c7783d4eb" . "d4f32" => base64_decode("bGRhcF9leHBsb2RlX2" . "Ru"), "_7f628626dd1d55c7" . "1b1fc0932ffd1d2c" => base64_decode("aXNfYXJyYX" . "k="), "_178966c8" . "ede126c06" . "bf5e5cc26" . "ef9bb3" => base64_decode("Tm90IGFuIE" . "xEQVAgdXNl" . "cg=="), "_a591754a8ddcdbda9c" . "80f1db4d911e14" => base64_decode("aXNfbn" . "VsbA=="), "_cdcf6e94ffc" . "095d29538c48" . "24c1dba56" => base64_decode("Z" . "G" . "U" . "="), "_4278f6e1f1e27cc1e96763e4620a4ff" . "5" => base64_decode("Y21fZG" . "ll"), "_211bd0cc94" . "64721ec1305" . "8e6b5a9a591" => base64_decode("dXNlcnByaW5jaXBhbG" . "5hbWU="), "_8ff0e2c6dc53989c3" . "7139dd673c9ef80" => base64_decode("X" . "A" . "=" . "="), "_81166ff3e" . "9c179025b1" . "6a3404e7f7" . "758" => base64_decode("RmFpbGVkIHRvIGdldCBzdGFuZGFyZCB1c2VybmFtZSBmcm9tIHByb3BlcnRpZXMgJ3VzZXJwcmluY2" . "lwYWxuYW1lJyBhbmQgJw=="), "_4d707fab93bebb00bbe69e8159697c" . "90" => base64_decode(""), "_c96c5a266f9148" . "4f929b4333093dc" . "ede" => base64_decode("RW1wdHkgdXN" . "lcm5hbWUh"), "_f9544f667576ee583b77d092152" . "97691" => base64_decode("c3RyaXBvcw" . "=="), "_4e306db4c4b" . "e96ad112eb80" . "084bb9348" => base64_decode("VGhpcyBhY2NvdW50IGRvZXMgbm90IGJ" . "lbG9uZyB0byBhIHVzZXI="), "_28c85ce81fee653298026" . "2893b6f2425" => base64_decode("dXNlcm5h" . "bWU="), "_53e519c06" . "eb01660e36" . "7876cdd838" . "5f2" => base64_decode("ZXh0" . "X2lk"), "_4592b1201713" . "114a11390e0bb" . "87e680d" => base64_decode("Z" . "G" . "4" . "="), "_64f204efc0" . "caf630ef68b" . "ca568adbb53" => base64_decode("ZXh0X3R5cGU" . "="), "_7957e500bc50ac1b8f4c" . "21b31f14575c" => base64_decode("QmluZFVzZXI6IGJpbmRpbmcgdG8gZGl" . "yZWN0b3J5IGNvbm5lY3Rpb24gYXMg"));
use Claromentis\Core\User\Directory\DirectorySettings;
use Claromentis\Core\User\Directory\Exception\LdapBindFailedException;
use Claromentis\Core\User\Directory\Exception\LdapLogicException;
use Claromentis\Core\User\Directory\Exception\LdapOperationException;
use Claromentis\Core\User\Directory\Exception\LdapUserNotAllowedException;
use Claromentis\Core\User\Directory\Exception\UnsupportedUserTypeException;
use Claromentis\Core\User\Directory\Exception\UsersDirectoryException;
use Claromentis\Core\User\Directory\ExternalUserInfo;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerGroup;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerOU;
use Claromentis\Core\User\Directory\Ldap\Container\ContainersCollection;
use Claromentis\Core\User\Directory\Ldap\Container\UsersContainerInterface;
use Claromentis\Core\User\Directory\UserDateProviderInterface;
use Claromentis\Core\User\Directory\UsersDirectoryInterface;
use CryptUtils;
use Exception;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use User;








class LdapDirectory implements UsersDirectoryInterface, UserDateProviderInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;
    const DIRECTORY_TYPE = 'ldap';
    const DEFAULT_DATE_FORMAT = 'YmdHis.0\\Z';
    const DEFAULT_DATE_WITHOUT_YEAR_FORMAT = 'm-d';
    
    
    
    
    protected $data_parser;
    
    
    
    
    protected $config;
    
    
    
    
    protected $ldap_settings;
    
    
    
    
    protected $connection;
    
    
    
    
    protected $dir_key;
    protected static $groups_rid_cache = null;
    
    
    
    
    protected $name_translate = null;
    public function __construct(LdapSettings $_f56e92e2b328797520a80ee0c4fb95c5, string $_4cf5e7200d92ab57a631fec17739af9b, DataParserInterface $_a4b96b27e3b10c1a4523813f13b9343d, LoggerInterface $logger = null)
    {
        $this->ldap_settings = $_f56e92e2b328797520a80ee0c4fb95c5;
        $this->setLogger($logger ?? new NullLogger());
        $this->connection = new LdapDirectConnection($this->ldap_settings->server_url, [], $this->logger);
        $this->connection->SetServiceAccount($this->ldap_settings->user, $this->ldap_settings->password);
        $this->data_parser = $_a4b96b27e3b10c1a4523813f13b9343d;
        $this->dir_key = $_4cf5e7200d92ab57a631fec17739af9b;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function FetchExternalUserInfo(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646)
    {
        $_c031077013afa9973ad3516e1ad65118 = $this->GetUserDn($_b038d88c53d0ea3f6bc6c39a6fc77646);
        $_ab45cd2ff0b3084c7533a223b3b093e1 = $this->GetLDAPUserInfo($_c031077013afa9973ad3516e1ad65118, true);
        $_c031077013afa9973ad3516e1ad65118 = $_ab45cd2ff0b3084c7533a223b3b093e1[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_ef19287a2" . "ea5e1fa755" . "2d942c1475" . "2f9"]];
        $this->EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type = $this->GetDirKey();
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id = $_c031077013afa9973ad3516e1ad65118;
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields = $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_f73dab606630b388645c4f7" . "d3fbb13bb"]($_b038d88c53d0ea3f6bc6c39a6fc77646->fields, $_ab45cd2ff0b3084c7533a223b3b093e1);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_64f204efc0caf630ef68bca568a" . "dbb53"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type];
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_53e519c06eb01660e367" . "876cdd8385f2"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id];
    }
    
    
    
    
    
    
    
    
    
    protected function GetUserDn(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646) : string
    {
        $_4a033bdf0ce701c6255d5238633ab2d0 = $_b038d88c53d0ea3f6bc6c39a6fc77646->service_data;
        $this->logger->debug($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_9777893780444e7" . "99e6e71df931556d" . "0"] . $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_28c85ce81fee6" . "532980262893b6" . "f2425"]]);
        $_9961f986823b4be7f5c4cc8379c6b228 = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_1bee3d4d1d0df49e0fcf" . "8b9ed2ecb8fa"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_8ff0e2c6dc53989" . "c37139dd673c9ef8" . "0"], $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_28c85ce81fee653298026289" . "3b6f2425"]]);
        if ($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_70979d287fa2c98d21aa07834c259" . "a52"]($this->ldap_settings->domain) !== $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_70979d287fa2c98" . "d21aa07834c259a5" . "2"]($_9961f986823b4be7f5c4cc8379c6b228[0])) {
            throw new UnsupportedUserTypeException($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_178966c8" . "ede126c06" . "bf5e5cc26" . "ef9bb3"]);
        }
        if ($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type === $this->GetDirKey() && !empty($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id)) {
            $_c031077013afa9973ad3516e1ad65118 = $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id;
        } elseif ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_7f628626dd1d55c71b" . "1fc0932ffd1d2c"]($_4a033bdf0ce701c6255d5238633ab2d0) && isset($_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_ef19287a2ea5e1fa7552d942c1475" . "2f9"]])) {
            $_c031077013afa9973ad3516e1ad65118 = $_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_ef19287a2" . "ea5e1fa755" . "2d942c1475" . "2f9"]];
        } else {
            $_c031077013afa9973ad3516e1ad65118 = $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_4d707fab93be" . "bb00bbe69e815" . "9697c90"];
        }
        if ($this->IsDn($_c031077013afa9973ad3516e1ad65118)) {
            return $_c031077013afa9973ad3516e1ad65118;
        }
        if (!empty($_c031077013afa9973ad3516e1ad65118)) {
            $_28c85ce81fee6532980262893b6f2425 = $_c031077013afa9973ad3516e1ad65118;
        } else {
            $_28c85ce81fee6532980262893b6f2425 = $_b038d88c53d0ea3f6bc6c39a6fc77646->GetUsername();
        }
        if ($_28c85ce81fee6532980262893b6f2425 == $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_4d707fab93bebb00bbe69e815969" . "7c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_c96c5a266f91484f929b4333093" . "dcede"]);
        }
        $_c031077013afa9973ad3516e1ad65118 = $this->GetNameTranslate()->GetUserDN($_28c85ce81fee6532980262893b6f2425);
        return $_c031077013afa9973ad3516e1ad65118;
    }
    
    
    
    
    
    
    
    
    protected function IsDn(string $_9a0b5569f06c8394f7fab90dbd9bc163) : bool
    {
        if ($_9a0b5569f06c8394f7fab90dbd9bc163 === $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4d707fab93bebb00bbe69e8159697c9" . "0"]) {
            return false;
        }
        return $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8f65c3c3" . "84b75d89f" . "9c7783d4e" . "bd4f32"]($_9a0b5569f06c8394f7fab90dbd9bc163, false) !== false;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function CheckPassword($_28c85ce81fee6532980262893b6f2425, $_e0637eee905ebe3938c5da50e3db10d7)
    {
        if (!$this->IsDomainUser($_28c85ce81fee6532980262893b6f2425)) {
            throw new UnsupportedUserTypeException();
        }
        $this->BindUser($_28c85ce81fee6532980262893b6f2425, CryptUtils::RC4($_e0637eee905ebe3938c5da50e3db10d7, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_4298577e41894bcce" . "23f896cd365aea4"]));
    }
    protected function IsDomainUser($_28c85ce81fee6532980262893b6f2425)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f9544f667576ee583b7" . "7d09215297691"]($_28c85ce81fee6532980262893b6f2425, $this->ldap_settings->domain . $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_8ff0e2c6dc53989c37139dd" . "673c9ef80"]) === 0) {
            return true;
        }
        return false;
    }
    
    
    
    
    
    
    
    
    
    public function GetReadonlyUserProfileFields(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return array();
        }
        $_122532f21c38b4934972bf1659a76920 = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_d706c160e45bf7434fff82" . "a5976f0e19"]($this->ldap_settings->fields_map);
        $_122532f21c38b4934972bf1659a76920[] = $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_28c85ce81" . "fee6532980" . "262893b6f2" . "425"];
        return $_122532f21c38b4934972bf1659a76920;
    }
    
    
    
    
    
    
    public function Enabled()
    {
        return $this->ldap_settings->enabled;
    }
    
    
    
    
    
    
    
    
    
    
    
    protected function GetNameTranslate()
    {
        if ($this->name_translate == null) {
            $this->name_translate = new NameTranslate($this->connection, $this->ldap_settings, $this->logger);
        }
        return $this->name_translate;
    }
    
    
    
    
    
    
    
    
    protected function EnsureConnected()
    {
        
        
        
        $this->connection->Connect();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function BindUser($_24e0e36600d6af77406a44bb618a6253 = null, $_c09fdb3aaf264bb220f143d800a9afd5 = '')
    {
        $this->connection->Connect();
        $this->logger->debug($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_7957e500bc50ac1b8f4c21b3" . "1f14575c"] . $_24e0e36600d6af77406a44bb618a6253);
        $_fe0e8a022de5ead12d68c99e07c2847d = $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_a591754a8ddcdb" . "da9c80f1db4d911" . "e14"]($_24e0e36600d6af77406a44bb618a6253);
        if ($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_a591754a8ddcdbda9c80f1d" . "b4d911e14"]($_24e0e36600d6af77406a44bb618a6253)) {
            $_24e0e36600d6af77406a44bb618a6253 = $this->ldap_settings->user;
            $_e0637eee905ebe3938c5da50e3db10d7 = $this->ldap_settings->password;
        } else {
            $_e0637eee905ebe3938c5da50e3db10d7 = CryptUtils::RC4($_c09fdb3aaf264bb220f143d800a9afd5, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_cdcf6e94ffc095d29538c4824c1d" . "ba56"]);
        }
        if ($this->ldap_settings->bind_by_dn) {
            if ($_24e0e36600d6af77406a44bb618a6253 == $this->ldap_settings->user || $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_d155d43a39de93f85" . "8123c6b6ce31d8a"]($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_7a6839269cdf25d8" . "75660c6a857fbf8d"], $_24e0e36600d6af77406a44bb618a6253)) {
                
                
                $_39db25051c3981e849efcb9dffcfdcf6 = $_24e0e36600d6af77406a44bb618a6253;
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $this->GetNameTranslate()->GetUserDN($_24e0e36600d6af77406a44bb618a6253);
            }
        } else {
            $_cc7a304be0dc5735413298c4ee5847f6 = $this->ParseDomainUserName($_24e0e36600d6af77406a44bb618a6253);
            if ($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_aed8da0f19091214b78f80351048517" . "c"]($_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_094a90ab5fdba7fad8a" . "6b3c2c7287bbf"]]) > 0) {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_094a90ab5fdba7fad" . "8a6b3c2c7287bbf"]] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_8ff0e2c6dc53989c37139dd673c9e" . "f80"] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_28c85ce" . "81fee653" . "29802628" . "93b6f242" . "5"]];
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_28c85ce81fee6532980262893b6f" . "2425"]] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_c906bc81dd9c0320" . "ede9a60004ee65af"]];
            }
        }
        if ($_fe0e8a022de5ead12d68c99e07c2847d) {
            $this->connection->SetServiceAccount($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
        } else {
            try {
                $this->connection->Bind($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
            } catch (LdapBindFailedException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
                throw new LdapBindFailedException($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_ef0abf4494e1bd7519" . "b5603ea9e241fc"] . $_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
            }
        }
        return true;
    }
    protected function EnsureConnectedBound()
    {
        $this->EnsureConnected();
    }
    
    
    
    
    protected function GetUsersContainer()
    {
        $_14e7d5dee412ccf516939d1e99c87733 = $this->ldap_settings->groups;
        $_2a2b1a41820d69b88d2dbb547389945d = $this->ldap_settings->ous;
        $_5e4594441b0e531bfd6f0011e0327611 = new ContainersCollection();
        if (!empty($_2a2b1a41820d69b88d2dbb547389945d)) {
            if ($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_7f628626dd1d55c71b1f" . "c0932ffd1d2c"]($_2a2b1a41820d69b88d2dbb547389945d)) {
                foreach ($_2a2b1a41820d69b88d2dbb547389945d as $_8fe302831dde8820e73faace6fd81b11) {
                    $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_8fe302831dde8820e73faace6fd81b11, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
                }
            } else {
                $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_2a2b1a41820d69b88d2dbb547389945d, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
            }
        }
        if (!empty($_14e7d5dee412ccf516939d1e99c87733)) {
            if ($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_7f628626d" . "d1d55c71b1" . "fc0932ffd1" . "d2c"]($_14e7d5dee412ccf516939d1e99c87733)) {
                foreach ($_14e7d5dee412ccf516939d1e99c87733 as $_e9208e4fb555ac989f7519e19c1da810) {
                    $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_e9208e4fb555ac989f7519e19c1da810, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
                }
            } else {
                $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_14e7d5dee412ccf516939d1e99c87733, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
            }
        }
        return $_5e4594441b0e531bfd6f0011e0327611;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118)
    {
        $_e84a1b9eb8ec9d4f0cea0b9b922bdf62 = $this->GetUsersContainer();
        if (!$_e84a1b9eb8ec9d4f0cea0b9b922bdf62->IsMember($_c031077013afa9973ad3516e1ad65118)) {
            throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_9d799ff" . "313bcf1d" . "d5c17f00" . "4da40f23" . "1"] . $_c031077013afa9973ad3516e1ad65118 . $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_e4cff6b52204dc59b3dc7f" . "210b3150d3"]);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function GetLDAPUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        $_8e4f4231f852f06b05789873e3eb14eb = $this->GetRawUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9);
        $_147aa65e6f86b03cd87a88a580320c7e = $this->GetUserInfoFromRaw($_8e4f4231f852f06b05789873e3eb14eb);
        if ($this->ldap_settings->map_groups !== null && $this->ldap_settings->map_groups != LdapSettings::GROUP_MAP_DISABLED) {
            $_147aa65e6f86b03cd87a88a580320c7e[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_af50df82a057b1" . "0a621d476dcfd58" . "b99"]] = $this->GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb);
        }
        return $_147aa65e6f86b03cd87a88a580320c7e;
    }
    protected function GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb)
    {
        $_8067f2d8e4fa1ba80f660e4b1abc5e3f = isset($_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_ca5863bab59cc6b" . "eb91e24291044d42" . "a"]]) ? $_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_ca5863bab59cc6beb" . "91e24291044d42a"]] : [];
        if (!$_8067f2d8e4fa1ba80f660e4b1abc5e3f) {
            return [];
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        switch ($this->ldap_settings->map_groups) {
            case LdapSettings::GROUP_MAP_ENABLED:
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8f65c3c384b75d" . "89f9c7783d4ebd4" . "f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_OU:
                $_8fe302831dde8820e73faace6fd81b11 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_0c92cd3347f4e1cd8b2c48fbd1c2964d = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_f9544f667576e" . "e583b77d092152" . "97691"]($_74a34a7dc25078df9e146af189ce38fb, $_8fe302831dde8820e73faace6fd81b11);
                    if ($_0c92cd3347f4e1cd8b2c48fbd1c2964d === false || $_0c92cd3347f4e1cd8b2c48fbd1c2964d + $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_aed8da0f19091214b78f" . "80351048517c"]($_8fe302831dde8820e73faace6fd81b11) !== $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_aed8da0f19091214b78" . "f80351048517c"]($_74a34a7dc25078df9e146af189ce38fb)) {
                        continue;
                    }
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_8f65c3c384b75d89f9c7783d" . "4ebd4f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_REGEX:
                $_ff52b0cc081aebf6724dddf29003ec05 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8f65c3c38" . "4b75d89f9c" . "7783d4ebd4" . "f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (!isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        continue;
                    }
                    if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_d155d43a39de93f858123c6b6ce" . "31d8a"]($_ff52b0cc081aebf6724dddf29003ec05, $_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    protected function GetUserInfoFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetDataFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0, $this->ldap_settings);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4278f6e1f1e27cc1e96763e" . "4620a4ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    protected function GetPropertyValue($_ff02a3ae2d972df289e22f96c7b89ce4, $_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetValueByExpression($_dbdfe9ef6c70506bf0730dfd58ea52a0, $_ff02a3ae2d972df289e22f96c7b89ce4);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_4278f6e1f1e27cc1e96763e4620a4" . "ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetRawUserInfo($_c060acb51130a54b61ab31ad8bbac121, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        static $last_found_user = null;
        static $last_found_dn = null;
        static $last_found_user_info = null;
        if ($_c060acb51130a54b61ab31ad8bbac121 == $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_4d707fab93bebb00bbe69" . "e8159697c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_12223d821ca33ae8d" . "28c4447e3eaf058"], 24);
        }
        if ($last_found_user == $_c060acb51130a54b61ab31ad8bbac121 || $last_found_dn == $_c060acb51130a54b61ab31ad8bbac121) {
            return $last_found_user_info;
        }
        try {
            $this->EnsureConnectedBound();
            if (!$_69faa59f62ba3f97a51512e4e7236db9) {
                $_4592b1201713114a11390e0bb87e680d = $this->GetNameTranslate()->GetUserDN($_c060acb51130a54b61ab31ad8bbac121);
            } else {
                $_4592b1201713114a11390e0bb87e680d = $_c060acb51130a54b61ab31ad8bbac121;
            }
            $_6aead4bff5639b251aebcf8a630e43a7 = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $this->ldap_settings->user_type_filter);
            if (!$_6aead4bff5639b251aebcf8a630e43a7) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_4e306db4c4be96ad112eb8008" . "4bb9348"], 22);
            }
        } catch (LdapUserNotAllowedException $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw $_445ae8a7d426a19b37bd4f87091b7f30;
        } catch (Exception $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw new UsersDirectoryException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_5ff1b1d66ba406be91" . "8cf9d21d95d870"] . $_445ae8a7d426a19b37bd4f87091b7f30->getMessage(), $_445ae8a7d426a19b37bd4f87091b7f30->getCode());
        }
        $_d895cb60bf79b51077a88f4cf5d0e6b5 = $this->ldap_settings->user_enabled_filter;
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_aed8da0f1909121" . "4b78f80351048517" . "c"]($_d895cb60bf79b51077a88f4cf5d0e6b5) > 0) {
            $_371119a328eb895c2d8cf2d55855804e = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $_d895cb60bf79b51077a88f4cf5d0e6b5);
            if (!$_371119a328eb895c2d8cf2d55855804e) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_a9148efa986a9" . "a8d8f1f5281c6e" . "df49e"], 25);
            }
        }
        $_16c3b779dbe80d626e0d3710d09590fe = $this->ldap_settings->username_field;
        if (isset($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_70979d287fa2c98" . "d21aa07834c259a5" . "2"]($_16c3b779dbe80d626e0d3710d09590fe)])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_70979d287fa2c98d21aa07" . "834c259a52"]($_16c3b779dbe80d626e0d3710d09590fe)][0];
        } elseif ($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_aed8da0f19091214b78f80351048" . "517c"]($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_211bd0cc9464721ec130" . "58e6b5a9a591"]][0])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_211bd0cc9464721ec13058e6b5a9a" . "591"]][0];
        } else {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$_16c3b779dbe80d626e0d3710d09590fe][0];
        }
        if ($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_aed8da0f19091214b78f" . "80351048517c"]($_22b288e3b4e428769d167bb848c14cd0) == 0) {
            throw new LdapOperationException($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_81166ff3" . "e9c179025" . "b16a3404e" . "7f7758"] . $_16c3b779dbe80d626e0d3710d09590fe . $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_e608e5b5c4c3" . "4a67ba97ef84c" . "1e16199"]);
        }
        $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_c230c83684d3ea5d367c6d86c16c" . "0431"]] = $this->StandardizeUserName($_22b288e3b4e428769d167bb848c14cd0);
        if (!$_69faa59f62ba3f97a51512e4e7236db9) {
            $last_found_user = $_c060acb51130a54b61ab31ad8bbac121;
            $last_found_dn = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_4592b1201713114a113" . "90e0bb87e680d"]];
        } else {
            $last_found_user = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_c230c83684d" . "3ea5d367c6d8" . "6c16c0431"]];
            $last_found_dn = $_c060acb51130a54b61ab31ad8bbac121;
        }
        $last_found_user_info = $_6aead4bff5639b251aebcf8a630e43a7;
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    
    
    
    
    public function GetConnectionHandler()
    {
        $this->EnsureConnectedBound();
        return $this->connection;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function ParseDomainUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->ParseDomainUserName($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function StandardizeUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->GetNT4Name($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    public function GetUsersList()
    {
        $this->EnsureConnectedBound();
        $_5e4594441b0e531bfd6f0011e0327611 = $this->GetUsersContainer();
        $_b8f0500f7ec3de46e7358d52b895766a = $_5e4594441b0e531bfd6f0011e0327611->GetMembers();
        $_1519187376d66e1277bb574c97704a93 = [];
        foreach ($_b8f0500f7ec3de46e7358d52b895766a as $_28c85ce81fee6532980262893b6f2425 => $_c031077013afa9973ad3516e1ad65118) {
            $_e040648b744a44c96359dd803b6aa26a = $this->StandardizeUserName($_28c85ce81fee6532980262893b6f2425);
            $_d849cce608c34e14e0534b28c67a6b89 = new ExternalUserInfo($this->GetDirKey(), $_c031077013afa9973ad3516e1ad65118);
            $_d849cce608c34e14e0534b28c67a6b89->SetUsername($_e040648b744a44c96359dd803b6aa26a);
            $_1519187376d66e1277bb574c97704a93[] = $_d849cce608c34e14e0534b28c67a6b89;
        }
        return $_1519187376d66e1277bb574c97704a93;
    }
    
    
    
    
    
    
    
    
    public function UserBelongs(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return false;
        }
        return $_24e0e36600d6af77406a44bb618a6253->GetExtType() == $this->dir_key;
    }
    public function GetDirKey()
    {
        return $this->dir_key;
    }
    public function GetName()
    {
        return $this->ldap_settings->domain;
    }
    
    
    
    
    public function GetDirectorySettings()
    {
        return $this->ldap_settings;
    }
    public function GetDateFormat() : string
    {
        $_d3db06402a34baad2560c7da8a5f9fea = $this->ldap_settings->date_format;
        if (empty($_d3db06402a34baad2560c7da8a5f9fea)) {
            $_d3db06402a34baad2560c7da8a5f9fea = self::DEFAULT_DATE_FORMAT;
        }
        return $_d3db06402a34baad2560c7da8a5f9fea;
    }
    public function GetDateNoYearFormat() : string
    {
        $_256499a511fb5270d7961718f37cf545 = $this->ldap_settings->date_no_year_format;
        if (empty($_256499a511fb5270d7961718f37cf545)) {
            $_256499a511fb5270d7961718f37cf545 = self::DEFAULT_DATE_WITHOUT_YEAR_FORMAT;
        }
        return $_256499a511fb5270d7961718f37cf545;
    }
}