var moduleName = 'commentsModule';
var module;

try {
	module = angular.module(moduleName);
} catch(err) {
	// named module does not exist, so create one
	module = angular.module(moduleName, ['ngResource', 'fileupload', 'doclink', 'link', 'mention', 'annotations', 'cla.core.lmsg', 'cla.core.growl']);
}

module.filter("sanitize", ['$sce', function ($sce) {
    return function (htmlCode) {
        return $sce.trustAsHtml(htmlCode);
    }
}]);
