define(['jquery', 'jquery.tablednd'], function (jQuery) {
    return function () {
        jQuery("#changed_notify").css({'position' : 'absolute'});
        jQuery("#fields_list_table").tableDnD({
            onDragClass: "active",
            dragHandle: '.js-drag-handle',
            onDrop: function(table, row)
            {
                var rows = table.tBodies[0].rows;
                var values = [];
                for (var i=0; i<rows.length; i++)
                {
                    values[i] = rows[i].id.substr(4);
                }
                xajax_fields_save_order(jQuery('#project_id').val(), values);
            }
        });
    };
});

function flash_confirm(text)
{
    var element = jQuery("#changed_notify");
    element.removeClass('d-none');
    var margins = element.outerWidth() - element.width();
    element.html(text);
    var new_width = jQuery('#fields_list_table').outerWidth() - margins;
    element.clearQueue().fadeIn().width(new_width).fadeIn(1000).delay(2000).fadeOut(1000);
}

function after_hide_field(code)
{
    var tr = jQuery(document.getElementById('ilf_' + code));
    var title = jQuery('.field_title', tr).text();

    var opt = jQuery('<option selected="selected"></option>').val(code).text(title);
    var new_field_select = jQuery('#new_field_select');
    new_field_select.prepend(opt);
    new_field_select[0].selectedIndex = 0;
    new_field_select[0].className = new_field_select[0].className;

    tr.detach();
    flash_confirm(lmsg('people.peopleadmin_fields.field_is_hidden'));
}

function after_remove_field(code)
{
    var tr = jQuery(document.getElementById('ilf_' + code));
    var title = jQuery('.field_title', tr).text();

    var opt = jQuery('<option selected="selected"></option>').val(code).text(title);
    var new_field_select = jQuery('#new_field_select');
    new_field_select.prepend(opt);
    new_field_select[0].selectedIndex = 0;
    new_field_select[0].className = new_field_select[0].className;

    tr.detach();
    flash_confirm(lmsg('people.peopleadmin_fields.field_is_removed'));
}
