<?php
// 7.1 alpha
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");

/* Script "01_image_comments.php" starts */ 

$db->query("INSERT INTO comments (user_id, date_created, object_id, aggregation, comment_text) SELECT user_id, time_left, image_id, 15, image_comment FROM image_comments"); // 15 is AGGREGATION_IMAGE_GALLERY
$db->DropTable('image_comments');


 /* Script "01_image_comments.php" ends */ 
 /* Script "02_news_comments.php" starts */ 

$db->AddColumn('comments', 'status', "INT NOT_NULL DEFAULT 1");
$db->AddColumn('comments', 'parent_id', "INT NOT_NULL DEFAULT 0");
$db->AddColumn('comments', 'reply_count', "INT NOT_NULL DEFAULT 0");

$db->query("INSERT INTO comments (user_id, date_created, object_id, aggregation, comment_text, status)
			SELECT user_id, date_created, news_id, 21, comment_text, status FROM news_comments");
		 // 21 is AGGREGATION_NEWS
		 // status can be one of NewsItem::COMMENTS_ENABLED=1 or NewsItem::COMMENTS_MODERATED=2

//$db->DropTable('news_comments');  // not dropping it to keep "rate" for suture conversion into "likes"



 /* Script "02_news_comments.php" ends */ 
 /* Script "03_profile_top_fields.php" starts */ 

UsersFieldsConfigAdmin::SetFieldsViewProfileTop(array('fullname', 'job_title', 'emailad'));
$cur_fields = UsersFieldsConfig::GetFieldsViewProfile();
$cur_fields = array_diff($cur_fields, array('fullname', 'job_title', 'emailad'));
UsersFieldsConfigAdmin::SetFieldsViewProfile($cur_fields);




 /* Script "03_profile_top_fields.php" ends */ 
 /* Script "04_news_dates.php" starts */ 

$db->query("UPDATE news SET date_end=0 WHERE date_end IS NULL");
$db->query("UPDATE news SET date_end=0 WHERE headline=1 AND is_sticky=0");

$db->AlterColumn('news', 'date_end', 'date_end', "INT_DATE NOT_NULL default 0");


 /* Script "04_news_dates.php" ends */ 
 /* Script "05_news_perms.php" starts */ 

// delete individual news permissions for non-announcements
$db->query("DELETE FROM permissions WHERE class_id=5 AND object_id NOT IN (SELECT id FROM news WHERE headline=0)"); // 5 is PERM_CLASS_NEWS


 /* Script "05_news_perms.php" ends */ 
 /* Script "06_exarea_for_groups_and_roles.php" starts */ 

$db->AlterColumn('groups', 'owner_id', 'owner', 'INT NOT_NULL DEFAULT 0');
$db->AlterColumn('groups', 'create_date', 'date_created', "INT_DATE NULL");
$db->AlterColumn('roles', 'date_create', 'date_created', "INT_DATE NULL");

$db->AddColumn('groups', 'ex_area_id', "INT NOT_NULL DEFAULT 0");
$db->AddColumn('roles', 'ex_area_id', "INT NOT_NULL DEFAULT 0");


 /* Script "06_exarea_for_groups_and_roles.php" ends */ 
 /* Script "07_search_recommendations.php" starts */ 

$db->query("INSERT INTO panels (name, filename, symname) VALUES ('Search', '../search/admin.php', 'search')");
$panelid = $db->insertId();
if ($panelid)
{
	$db->query("INSERT INTO administrators (panelid, userid) VALUES (int:p_id, 1)", $panelid);
}

$table_descr = array(
	'id' => 'IDENTITY',
	'name' => 'VARCHAR(100)',
	'created' => 'INT_DATE',
	'updated' => 'INT_DATE'
);
$db->CreateTable('search_suggestions_group', $table_descr, true);

$table_descr = array(
	'id' => 'IDENTITY',
	'group_id' => 'INT NOT_NULL',
	'value' => 'VARCHAR(500)',
	'created' => 'INT_DATE',
	'updated' => 'INT_DATE'
);
$db->CreateTable('search_suggestions_term', $table_descr, true);

$table_descr = array(
	'id' => 'IDENTITY',
	'group_id' => 'INT NOT_NULL',
	'value' => 'VARCHAR(500)',
	'created' => 'INT_DATE',
	'updated' => 'INT_DATE'
);
$db->CreateTable('search_suggestions_suggestion', $table_descr, true);

$table_descr = array(
	'id' => 'IDENTITY',
	'group_id' => 'INT NOT_NULL',
	'context' => 'VARCHAR(100)',
	'application' => 'VARCHAR(100)',
	'name' => 'VARCHAR(500)',
	'description' => 'VARCHAR(1000)',
	'url' => 'VARCHAR(500)',
	'position' => 'INT',
	'created' => 'INT_DATE',
	'updated' => 'INT_DATE'
);
$db->CreateTable('search_suggestions_best_bet', $table_descr, true);

$table_descr = array(
	'id' => 'IDENTITY',
	'term' => 'VARCHAR(500)',
	'description' => 'VARCHAR(500)',
	'creator' => 'INT',
	'created' => 'INT_DATE',
	'updated' => 'INT_DATE'
);
$db->CreateTable('search_suggestions_request', $table_descr, true);

 /* Script "07_search_recommendations.php" ends */ 
 /* Script "08_search_suggestion_settings.php" starts */ 

$db->query(new QueryInsert('variables', array('str(255):var_name' => 'search_suggestion_notify_admin', 'str:var_value' => 1)));
$db->query(new QueryInsert('variables', array('str(255):var_name' => 'search_suggestion_notify_user', 'str:var_value' => 1)));


 /* Script "08_search_suggestion_settings.php" ends */ 
 /* Script "09_document_comments.php" starts */ 

$db->query("INSERT INTO comments (user_id, date_created, object_id, aggregation, comment_text, object_id2)
			SELECT author_id, date_created, doc_id, 4, comment_text, version FROM document_comments");
		 // 4 is AGGREGATION_DATA

$db->DropTable('document_comments');



 /* Script "09_document_comments.php" ends */ 
 /* Script "10_comments_index.php" starts */ 

$db->CreateIndex('comments', 'comments_aggr_object_id', 'aggregation', 'object_id');


 /* Script "10_comments_index.php" ends */ ?>
