angular.module('link', [])
    .directive('claLink', function ()
    {
        var TYPE_LINK = 1;

        return {
            restrict: 'E',

            scope: {},
            bindToController: {
                link: '=', // 2 way binding
				controlToken: '=' // 2 way binding
            },
            controllerAs: 'cl',

            /**
             * Controller
             */
            controller: function ()
            {
                var ctrl = this;

                this.$onInit = function() {
                    ctrl.reset();

                    ctrl.token = ctrl.controlToken || {};
                    ctrl.token.resetLink = function()
                    {
                        ctrl.reset();
                    }
                };

				ctrl.reset = function()
				{
					ctrl.link = {
						'original': '',
						'path': '',
						'type': TYPE_LINK // PHP Attachment::TYPE_LINK
					};
				};

                ctrl.update = function()
                {
                    ctrl.link.original = ctrl.link.path;
                };
            },

            templateUrl: '/intranet/comments/html/ui/link.html'
        }
    });
